<?php

namespace Ys\NetgsmSmsSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for smsGonder1NV2 StructType
 * Meta information extracted from the WSDL
 * - type: tns:smsGonder1NV2
 * @subpackage Structs
 */
class SmsGonder1NV2 extends AbstractStructBase
{
    /**
     * The username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The header
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $header;
    /**
     * The msg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $msg;
    /**
     * The gsm
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $gsm;
    /**
     * The encoding
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $encoding;
    /**
     * The startdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startdate;
    /**
     * The stopdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $stopdate;
    /**
     * The bayikodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bayikodu;
    /**
     * The filter
     * @var int
     */
    public $filter;
    /**
     * Constructor method for smsGonder1NV2
     * @uses SmsGonder1NV2::setUsername()
     * @uses SmsGonder1NV2::setPassword()
     * @uses SmsGonder1NV2::setHeader()
     * @uses SmsGonder1NV2::setMsg()
     * @uses SmsGonder1NV2::setGsm()
     * @uses SmsGonder1NV2::setEncoding()
     * @uses SmsGonder1NV2::setStartdate()
     * @uses SmsGonder1NV2::setStopdate()
     * @uses SmsGonder1NV2::setBayikodu()
     * @uses SmsGonder1NV2::setFilter()
     * @param string $username
     * @param string $password
     * @param string $header
     * @param string $msg
     * @param string[] $gsm
     * @param string $encoding
     * @param string $startdate
     * @param string $stopdate
     * @param string $bayikodu
     * @param int $filter
     */
    public function __construct($username = null, $password = null, $header = null, $msg = null, array $gsm = array(), $encoding = null, $startdate = null, $stopdate = null, $bayikodu = null, $filter = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setHeader($header)
            ->setMsg($msg)
            ->setGsm($gsm)
            ->setEncoding($encoding)
            ->setStartdate($startdate)
            ->setStopdate($stopdate)
            ->setBayikodu($bayikodu)
            ->setFilter($filter);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get header value
     * @return string|null
     */
    public function getHeader()
    {
        return $this->header;
    }
    /**
     * Set header value
     * @param string $header
     * @return \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2
     */
    public function setHeader($header = null)
    {
        // validation for constraint: string
        if (!is_null($header) && !is_string($header)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($header, true), gettype($header)), __LINE__);
        }
        $this->header = $header;
        return $this;
    }
    /**
     * Get msg value
     * @return string|null
     */
    public function getMsg()
    {
        return $this->msg;
    }
    /**
     * Set msg value
     * @param string $msg
     * @return \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2
     */
    public function setMsg($msg = null)
    {
        // validation for constraint: string
        if (!is_null($msg) && !is_string($msg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msg, true), gettype($msg)), __LINE__);
        }
        $this->msg = $msg;
        return $this;
    }
    /**
     * Get gsm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getGsm()
    {
        return isset($this->gsm) ? $this->gsm : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGsm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGsm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGsmForArrayConstraintsFromSetGsm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $smsGonder1NV2GsmItem) {
            // validation for constraint: itemType
            if (!is_string($smsGonder1NV2GsmItem)) {
                $invalidValues[] = is_object($smsGonder1NV2GsmItem) ? get_class($smsGonder1NV2GsmItem) : sprintf('%s(%s)', gettype($smsGonder1NV2GsmItem), var_export($smsGonder1NV2GsmItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gsm property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gsm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $gsm
     * @return \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2
     */
    public function setGsm(array $gsm = array())
    {
        // validation for constraint: array
        if ('' !== ($gsmArrayErrorMessage = self::validateGsmForArrayConstraintsFromSetGsm($gsm))) {
            throw new \InvalidArgumentException($gsmArrayErrorMessage, __LINE__);
        }
        if (is_null($gsm) || (is_array($gsm) && empty($gsm))) {
            unset($this->gsm);
        } else {
            $this->gsm = $gsm;
        }
        return $this;
    }
    /**
     * Add item to gsm value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2
     */
    public function addToGsm($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The gsm property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gsm[] = $item;
        return $this;
    }
    /**
     * Get encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->encoding;
    }
    /**
     * Set encoding value
     * @param string $encoding
     * @return \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: string
        if (!is_null($encoding) && !is_string($encoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encoding, true), gettype($encoding)), __LINE__);
        }
        $this->encoding = $encoding;
        return $this;
    }
    /**
     * Get startdate value
     * @return string|null
     */
    public function getStartdate()
    {
        return $this->startdate;
    }
    /**
     * Set startdate value
     * @param string $startdate
     * @return \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2
     */
    public function setStartdate($startdate = null)
    {
        // validation for constraint: string
        if (!is_null($startdate) && !is_string($startdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startdate, true), gettype($startdate)), __LINE__);
        }
        $this->startdate = $startdate;
        return $this;
    }
    /**
     * Get stopdate value
     * @return string|null
     */
    public function getStopdate()
    {
        return $this->stopdate;
    }
    /**
     * Set stopdate value
     * @param string $stopdate
     * @return \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2
     */
    public function setStopdate($stopdate = null)
    {
        // validation for constraint: string
        if (!is_null($stopdate) && !is_string($stopdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stopdate, true), gettype($stopdate)), __LINE__);
        }
        $this->stopdate = $stopdate;
        return $this;
    }
    /**
     * Get bayikodu value
     * @return string|null
     */
    public function getBayikodu()
    {
        return $this->bayikodu;
    }
    /**
     * Set bayikodu value
     * @param string $bayikodu
     * @return \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2
     */
    public function setBayikodu($bayikodu = null)
    {
        // validation for constraint: string
        if (!is_null($bayikodu) && !is_string($bayikodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bayikodu, true), gettype($bayikodu)), __LINE__);
        }
        $this->bayikodu = $bayikodu;
        return $this;
    }
    /**
     * Get filter value
     * @return int|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @param int $filter
     * @return \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: int
        if (!is_null($filter) && !(is_int($filter) || ctype_digit($filter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($filter, true), gettype($filter)), __LINE__);
        }
        $this->filter = $filter;
        return $this;
    }
}
