<?php

namespace Ys\NetgsmSmsSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rapor_v2 StructType
 * Meta information extracted from the WSDL
 * - type: tns:rapor_v2
 * @subpackage Structs
 */
class Rapor_v2 extends AbstractStructBase
{
    /**
     * The username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The bulkid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bulkid;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The version
     * @var int
     */
    public $version;
    /**
     * The telno
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $telno;
    /**
     * The detail
     * @var int
     */
    public $detail;
    /**
     * Constructor method for rapor_v2
     * @uses Rapor_v2::setUsername()
     * @uses Rapor_v2::setPassword()
     * @uses Rapor_v2::setBulkid()
     * @uses Rapor_v2::setStatus()
     * @uses Rapor_v2::setVersion()
     * @uses Rapor_v2::setTelno()
     * @uses Rapor_v2::setDetail()
     * @param string $username
     * @param string $password
     * @param string $bulkid
     * @param int $status
     * @param int $version
     * @param string[] $telno
     * @param int $detail
     */
    public function __construct($username = null, $password = null, $bulkid = null, $status = null, $version = null, array $telno = array(), $detail = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setBulkid($bulkid)
            ->setStatus($status)
            ->setVersion($version)
            ->setTelno($telno)
            ->setDetail($detail);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor_v2
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor_v2
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get bulkid value
     * @return string|null
     */
    public function getBulkid()
    {
        return $this->bulkid;
    }
    /**
     * Set bulkid value
     * @param string $bulkid
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor_v2
     */
    public function setBulkid($bulkid = null)
    {
        // validation for constraint: string
        if (!is_null($bulkid) && !is_string($bulkid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bulkid, true), gettype($bulkid)), __LINE__);
        }
        $this->bulkid = $bulkid;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor_v2
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor_v2
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !(is_int($version) || ctype_digit($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get telno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getTelno()
    {
        return isset($this->telno) ? $this->telno : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTelno method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelno method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelnoForArrayConstraintsFromSetTelno(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rapor_v2TelnoItem) {
            // validation for constraint: itemType
            if (!is_string($rapor_v2TelnoItem)) {
                $invalidValues[] = is_object($rapor_v2TelnoItem) ? get_class($rapor_v2TelnoItem) : sprintf('%s(%s)', gettype($rapor_v2TelnoItem), var_export($rapor_v2TelnoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The telno property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set telno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $telno
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor_v2
     */
    public function setTelno(array $telno = array())
    {
        // validation for constraint: array
        if ('' !== ($telnoArrayErrorMessage = self::validateTelnoForArrayConstraintsFromSetTelno($telno))) {
            throw new \InvalidArgumentException($telnoArrayErrorMessage, __LINE__);
        }
        if (is_null($telno) || (is_array($telno) && empty($telno))) {
            unset($this->telno);
        } else {
            $this->telno = $telno;
        }
        return $this;
    }
    /**
     * Add item to telno value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor_v2
     */
    public function addToTelno($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The telno property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->telno[] = $item;
        return $this;
    }
    /**
     * Get detail value
     * @return int|null
     */
    public function getDetail()
    {
        return $this->detail;
    }
    /**
     * Set detail value
     * @param int $detail
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor_v2
     */
    public function setDetail($detail = null)
    {
        // validation for constraint: int
        if (!is_null($detail) && !(is_int($detail) || ctype_digit($detail))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($detail, true), gettype($detail)), __LINE__);
        }
        $this->detail = $detail;
        return $this;
    }
}
