<?php

namespace Ys\NetgsmSmsSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for raporV3 StructType
 * Meta information extracted from the WSDL
 * - type: tns:raporV3
 * @subpackage Structs
 */
class RaporV3 extends AbstractStructBase
{
    /**
     * The username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The bulkid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bulkid;
    /**
     * The telno
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $telno;
    /**
     * The header
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $header;
    /**
     * The startdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startdate;
    /**
     * The stopdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $stopdate;
    /**
     * The type
     * @var int
     */
    public $type;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The detail
     * @var int
     */
    public $detail;
    /**
     * Constructor method for raporV3
     * @uses RaporV3::setUsername()
     * @uses RaporV3::setPassword()
     * @uses RaporV3::setBulkid()
     * @uses RaporV3::setTelno()
     * @uses RaporV3::setHeader()
     * @uses RaporV3::setStartdate()
     * @uses RaporV3::setStopdate()
     * @uses RaporV3::setType()
     * @uses RaporV3::setStatus()
     * @uses RaporV3::setDetail()
     * @param string $username
     * @param string $password
     * @param string $bulkid
     * @param string[] $telno
     * @param string $header
     * @param string $startdate
     * @param string $stopdate
     * @param int $type
     * @param int $status
     * @param int $detail
     */
    public function __construct($username = null, $password = null, $bulkid = null, array $telno = array(), $header = null, $startdate = null, $stopdate = null, $type = null, $status = null, $detail = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setBulkid($bulkid)
            ->setTelno($telno)
            ->setHeader($header)
            ->setStartdate($startdate)
            ->setStopdate($stopdate)
            ->setType($type)
            ->setStatus($status)
            ->setDetail($detail);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \Ys\NetgsmSmsSoap\StructType\RaporV3
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Ys\NetgsmSmsSoap\StructType\RaporV3
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get bulkid value
     * @return string|null
     */
    public function getBulkid()
    {
        return $this->bulkid;
    }
    /**
     * Set bulkid value
     * @param string $bulkid
     * @return \Ys\NetgsmSmsSoap\StructType\RaporV3
     */
    public function setBulkid($bulkid = null)
    {
        // validation for constraint: string
        if (!is_null($bulkid) && !is_string($bulkid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bulkid, true), gettype($bulkid)), __LINE__);
        }
        $this->bulkid = $bulkid;
        return $this;
    }
    /**
     * Get telno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getTelno()
    {
        return isset($this->telno) ? $this->telno : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTelno method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelno method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelnoForArrayConstraintsFromSetTelno(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $raporV3TelnoItem) {
            // validation for constraint: itemType
            if (!is_string($raporV3TelnoItem)) {
                $invalidValues[] = is_object($raporV3TelnoItem) ? get_class($raporV3TelnoItem) : sprintf('%s(%s)', gettype($raporV3TelnoItem), var_export($raporV3TelnoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The telno property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set telno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $telno
     * @return \Ys\NetgsmSmsSoap\StructType\RaporV3
     */
    public function setTelno(array $telno = array())
    {
        // validation for constraint: array
        if ('' !== ($telnoArrayErrorMessage = self::validateTelnoForArrayConstraintsFromSetTelno($telno))) {
            throw new \InvalidArgumentException($telnoArrayErrorMessage, __LINE__);
        }
        if (is_null($telno) || (is_array($telno) && empty($telno))) {
            unset($this->telno);
        } else {
            $this->telno = $telno;
        }
        return $this;
    }
    /**
     * Add item to telno value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ys\NetgsmSmsSoap\StructType\RaporV3
     */
    public function addToTelno($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The telno property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->telno[] = $item;
        return $this;
    }
    /**
     * Get header value
     * @return string|null
     */
    public function getHeader()
    {
        return $this->header;
    }
    /**
     * Set header value
     * @param string $header
     * @return \Ys\NetgsmSmsSoap\StructType\RaporV3
     */
    public function setHeader($header = null)
    {
        // validation for constraint: string
        if (!is_null($header) && !is_string($header)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($header, true), gettype($header)), __LINE__);
        }
        $this->header = $header;
        return $this;
    }
    /**
     * Get startdate value
     * @return string|null
     */
    public function getStartdate()
    {
        return $this->startdate;
    }
    /**
     * Set startdate value
     * @param string $startdate
     * @return \Ys\NetgsmSmsSoap\StructType\RaporV3
     */
    public function setStartdate($startdate = null)
    {
        // validation for constraint: string
        if (!is_null($startdate) && !is_string($startdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startdate, true), gettype($startdate)), __LINE__);
        }
        $this->startdate = $startdate;
        return $this;
    }
    /**
     * Get stopdate value
     * @return string|null
     */
    public function getStopdate()
    {
        return $this->stopdate;
    }
    /**
     * Set stopdate value
     * @param string $stopdate
     * @return \Ys\NetgsmSmsSoap\StructType\RaporV3
     */
    public function setStopdate($stopdate = null)
    {
        // validation for constraint: string
        if (!is_null($stopdate) && !is_string($stopdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stopdate, true), gettype($stopdate)), __LINE__);
        }
        $this->stopdate = $stopdate;
        return $this;
    }
    /**
     * Get type value
     * @return int|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param int $type
     * @return \Ys\NetgsmSmsSoap\StructType\RaporV3
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \Ys\NetgsmSmsSoap\StructType\RaporV3
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get detail value
     * @return int|null
     */
    public function getDetail()
    {
        return $this->detail;
    }
    /**
     * Set detail value
     * @param int $detail
     * @return \Ys\NetgsmSmsSoap\StructType\RaporV3
     */
    public function setDetail($detail = null)
    {
        // validation for constraint: int
        if (!is_null($detail) && !(is_int($detail) || ctype_digit($detail))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($detail, true), gettype($detail)), __LINE__);
        }
        $this->detail = $detail;
        return $this;
    }
}
