<?php

namespace Ys\NetgsmSmsSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rapor StructType
 * Meta information extracted from the WSDL
 * - type: tns:rapor
 * @subpackage Structs
 */
class Rapor extends AbstractStructBase
{
    /**
     * The username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The bulkid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bulkid;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The version
     * @var int
     */
    public $version;
    /**
     * Constructor method for rapor
     * @uses Rapor::setUsername()
     * @uses Rapor::setPassword()
     * @uses Rapor::setBulkid()
     * @uses Rapor::setStatus()
     * @uses Rapor::setVersion()
     * @param string $username
     * @param string $password
     * @param string $bulkid
     * @param int $status
     * @param int $version
     */
    public function __construct($username = null, $password = null, $bulkid = null, $status = null, $version = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setBulkid($bulkid)
            ->setStatus($status)
            ->setVersion($version);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get bulkid value
     * @return string|null
     */
    public function getBulkid()
    {
        return $this->bulkid;
    }
    /**
     * Set bulkid value
     * @param string $bulkid
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor
     */
    public function setBulkid($bulkid = null)
    {
        // validation for constraint: string
        if (!is_null($bulkid) && !is_string($bulkid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bulkid, true), gettype($bulkid)), __LINE__);
        }
        $this->bulkid = $bulkid;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !(is_int($version) || ctype_digit($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
