<?php

namespace Ys\NetgsmSmsSoap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sms ServiceType
 * @subpackage Services
 */
class Sms extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named smsGonderNNV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\NetgsmSmsSoap\StructType\SmsGonderNNV2 $parameters
     * @return \Ys\NetgsmSmsSoap\StructType\SmsGonderNNV2Response|bool
     */
    public function smsGonderNNV2(\Ys\NetgsmSmsSoap\StructType\SmsGonderNNV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->smsGonderNNV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named smsGonder1NV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2 $parameters
     * @return \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2Response|bool
     */
    public function smsGonder1NV2(\Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->smsGonder1NV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2Response|\Ys\NetgsmSmsSoap\StructType\SmsGonderNNV2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
