<?php

namespace Ys\NetgsmSmsSoap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Raporv ServiceType
 * @subpackage Services
 */
class Raporv extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named rapor_v2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\NetgsmSmsSoap\StructType\Rapor_v2 $parameters
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor_v2Response|bool
     */
    public function rapor_v2(\Ys\NetgsmSmsSoap\StructType\Rapor_v2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->rapor_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ys\NetgsmSmsSoap\StructType\Rapor_v2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
