<?php

namespace Ys\NetgsmSmsSoap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rapor ServiceType
 * @subpackage Services
 */
class Rapor extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named rapor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\NetgsmSmsSoap\StructType\Rapor $parameters
     * @return \Ys\NetgsmSmsSoap\StructType\RaporResponse|bool
     */
    public function rapor(\Ys\NetgsmSmsSoap\StructType\Rapor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->rapor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named raporV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\NetgsmSmsSoap\StructType\RaporV3 $parameters
     * @return \Ys\NetgsmSmsSoap\StructType\RaporV3Response|bool
     */
    public function raporV3(\Ys\NetgsmSmsSoap\StructType\RaporV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->raporV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ys\NetgsmSmsSoap\StructType\RaporResponse|\Ys\NetgsmSmsSoap\StructType\RaporV3Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
