<?php

namespace Ys\NetgsmSmsSoap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kredi ServiceType
 * @subpackage Services
 */
class Kredi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named kredi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\NetgsmSmsSoap\StructType\Kredi $parameters
     * @return \Ys\NetgsmSmsSoap\StructType\KrediResponse|bool
     */
    public function kredi(\Ys\NetgsmSmsSoap\StructType\Kredi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->kredi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ys\NetgsmSmsSoap\StructType\KrediResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
