<?php

namespace Ys\NetgsmSmsSoap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Gelensms ServiceType
 * @subpackage Services
 */
class Gelensms extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named gelensms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\NetgsmSmsSoap\StructType\Gelensms $parameters
     * @return \Ys\NetgsmSmsSoap\StructType\GelensmsResponse|bool
     */
    public function gelensms(\Ys\NetgsmSmsSoap\StructType\Gelensms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->gelensms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named gelensmsV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\NetgsmSmsSoap\StructType\GelensmsV2 $parameters
     * @return \Ys\NetgsmSmsSoap\StructType\GelensmsV2Response|bool
     */
    public function gelensmsV2(\Ys\NetgsmSmsSoap\StructType\GelensmsV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->gelensmsV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ys\NetgsmSmsSoap\StructType\GelensmsResponse|\Ys\NetgsmSmsSoap\StructType\GelensmsV2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
