<?php


namespace Ys\NetgsmSmsSoap;


use WsdlToPhp\PackageBase\AbstractSoapClientBase;
use Ys\NetgsmSmsSoap\ServiceType\Gelensms;
use Ys\NetgsmSmsSoap\ServiceType\Gondericiadlari;
use Ys\NetgsmSmsSoap\ServiceType\Kredi;
use Ys\NetgsmSmsSoap\ServiceType\Paketkampanya;
use Ys\NetgsmSmsSoap\ServiceType\Rapor;
use Ys\NetgsmSmsSoap\ServiceType\Raporv;
use Ys\NetgsmSmsSoap\ServiceType\Sms;
use Ys\NetgsmSmsSoap\ServiceType\Smsgondern;
use Ys\NetgsmSmsSoap\ServiceType\Smsgondernn;

class NetgsmClient
{

    #region fields

    /**
     * @var string
     */
    protected $userName;

    /**
     * @var string
     */
    protected $password;

    /**
     * @var string
     */
    protected $url = 'https://soap.netgsm.com.tr:8181/Sms_webservis/SMS';

    #endregion fields

    #region ctor

    /**
     * NetgsmClient constructor.
     * @param string $userName
     * @param string $password
     */
    public function __construct($userName,$password)
    {
        $this->userName = $userName;
        $this->password = $password;
    }

    #endregion ctor

    #region Properties

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param string $userName
     * @return NetgsmClient
     */
    public function setUserName($userName)
    {
        $this->userName = $userName;
        return $this;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param string $password
     * @return NetgsmClient
     */
    public function setPassword($password)
    {
        $this->password = $password;
        return $this;
    }

    /**
     * @param bool $wsdl
     * @return string
     */
    public function getUrl($wsdl = false)
    {
        $url = $this->url;

        if($wsdl){
            if(strpos(strtolower($url),'?wsdl') === false){
                $url .= '?wsdl';
            }
        }

        return $url;
    }

    /**
     * @param string $url
     * @return NetgsmClient
     */
    public function setUrl($url)
    {
        $this->url = $url;
        return $this;
    }

    #endregion Properties

    #region methods


    /**
     * @param \Ys\NetgsmSmsSoap\StructType\SmsGonderNNV2 $smsGonderNNV2
     * @return StructType\SmsGonderNNV2Response
     * @throws \Exception
     */
    public function smsGonderNNV2($smsGonderNNV2){
        $srv = $this->getServiceSms();
        $smsGonderNNV2->setUsername($this->getUserName())
            ->setPassword($this->getPassword())
            ->setEncoding('TR');
        if($srv->smsGonderNNV2($smsGonderNNV2) !== false){
            return $srv->getResult();
        }else{
            $err = $srv->getLastError();
            if(is_array($err)){
                $err = implode(' - ', $err);
            }
            throw new \Exception($err);
        }
    }

    /**
     * @param \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2 $smsGonder1NV2
     * @return StructType\SmsGonder1NV2Response
     * @throws \Exception
     */
    public function smsGonder1NV2($smsGonder1NV2){
        $srv = $this->getServiceSms();
        $smsGonder1NV2->setUsername($this->getUserName())
            ->setPassword($this->getPassword())
            ->setEncoding('TR');
        if($srv->smsGonder1NV2($smsGonder1NV2) !== false){
            return $srv->getResult();
        }else{
            $err = $srv->getLastError();
            if(is_array($err)){
                $err = implode(' - ', $err);
            }
            throw new \Exception($err);
        }
    }


    public function getMessageByReturnCode($returnCode, &$outSuccess){
        if(empty($returnCode)){
            $outSuccess = false;
            return 'Dönüş kodu boş.';
        }

        switch ($returnCode){
            case '20':
                $outSuccess = false;
                return 'Mesaj metni problemli veya sınırı aşıyor.';
                break;
            case '30':
                $outSuccess = false;
                return 'Geçersiz kullanıcı adı , şifre veya kullanıcınızın API erişim izni yok.';
                break;
            case '40':
                $outSuccess = false;
                return 'Mesaj başlığınızın (gönderici adınızın) sistemde tanımlı değil.';
                break;
            case '70':
                $outSuccess = false;
                return 'Hatalı sorgulama. Gönderdiğiniz parametrelerden birisi hatalı veya zorunlu alanlardan biri eksik.';
                break;
            case '80':
                $outSuccess = false;
                return 'Gönderim sınır aşımı.';
                break;
            case '100':
            case '101':
                $outSuccess = false;
                return 'Sistem hatası.';
                break;
            case '1000':
                $outSuccess = true;
                return 'SMSiniz başarıyla sistemimize ulaştı. 5 dk içinde gönderilecek.';
                break;
        }

        if(strlen($returnCode) < 4){
            $outSuccess = false;
            return 'Bilinmeyen dönüş kodu: ' . $returnCode;
        }
        $outSuccess = true;
        return 'SMSiniz başarıyla sistemimize ulaştı.';
    }

    #endregion methods

    #region utils

    /**
     * @return array
     */
    protected function getOptions(){
        $options = array(
            AbstractSoapClientBase::WSDL_URL => $this->getUrl(true),
            AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
        );
        return $options;
    }

    /**
     * @return Sms
     */
    protected function getServiceSms(){
        return new Sms($this->getOptions());
    }


    /**
     * @return Smsgondern
     */
    protected function getServiceSmsgondern(){
        return new Smsgondern($this->getOptions());
    }


    /**
     * @return Kredi
     */
    protected function getServiceKredi(){
        return new Kredi($this->getOptions());
    }

    /**
     * @return Paketkampanya
     */
    protected  function getServicePaketkampanya(){
        return new Paketkampanya($this->getOptions());
    }

    /**
     * @return Rapor
     */
    protected function getServiceRapor(){
        return new Rapor($this->getOptions());
    }

    /**
     * @return Raporv
     */
    protected function getServiceRaporv(){
        return new Raporv($this->getOptions());
    }

    /**
     * @return Gondericiadlari
     */
    protected function getServiceGondericiadlari(){
        return new Gondericiadlari($this->getOptions());
    }

    /**
     * @return Smsgondernn
     */
    protected function getServiceSmsgondernn(){
        return new Smsgondernn($this->getOptions());
    }

    /**
     * @return Gelensms
     */
    protected function getServiceGelensms(){
        return new Gelensms($this->getOptions());
    }




    #endregion utils


}