<?php


namespace Ysb\IPara\Response;


class ThreeDPaymentInitResponse extends BaseResponse
{

    #region fields

    /** @var string */
    protected $amount ;
    /** @var string */
    protected $orderId ;

    /** @var string */
    protected $threeDSecureCode;

    /** @var string */
    protected $publicKey;

    #endregion fields

    #region ctor

    /**
     * ThreeDPaymentInitResponse constructor.
     * @param array|null $postArray
     */
    public function __construct($postArray = null)
    {
        if(! is_array($postArray)){
            return;
        }
        if(isset($postArray['amount'])){
            $this->amount = $postArray['amount'];
        }
        if(isset($postArray['orderId'])){
            $this->orderId = $postArray['orderId'];
        }
        if(isset($postArray['publicKey'])){
            $this->publicKey = $postArray['publicKey'];
        }
        if(isset($postArray['threeDSecureCode'])){
            $this->threeDSecureCode = $postArray['threeDSecureCode'];
        }
        $this->fillFromObject((object)$postArray);
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param string $amount
     * @return ThreeDPaymentInitResponse
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param string $orderId
     * @return ThreeDPaymentInitResponse
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
        return $this;
    }

    /**
     * @return string
     */
    public function getThreeDSecureCode()
    {
        return $this->threeDSecureCode;
    }

    /**
     * @param string $threeDSecureCode
     * @return ThreeDPaymentInitResponse
     */
    public function setThreeDSecureCode($threeDSecureCode)
    {
        $this->threeDSecureCode = $threeDSecureCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getPublicKey()
    {
        return $this->publicKey;
    }

    /**
     * @param string $publicKey
     * @return ThreeDPaymentInitResponse
     */
    public function setPublicKey($publicKey)
    {
        $this->publicKey = $publicKey;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * @param array $postArray
     * @return ThreeDPaymentInitResponse
     */
    public static function fromPostArray($postArray){
        return new static($postArray);
    }

    #endregion statics

}