<?php


namespace Ysb\IPara\Response;


use Ysb\IPara\Entities\PaymentLinkRecord;

class LinkPaymentListResponse extends BaseResponse
{
    #region fields

    /** @var string */
    protected $pageIndex;

    /** @var string */
    protected $pageSize;

    /** @var string */
    protected $pageCount;

    /** @var array|PaymentLinkRecord[] */
    protected $paymentLinkRecords = array();

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getPageIndex()
    {
        return $this->pageIndex;
    }

    /**
     * @param string $pageIndex
     * @return LinkPaymentListResponse
     */
    public function setPageIndex($pageIndex)
    {
        $this->pageIndex = $pageIndex;
        return $this;
    }

    /**
     * @return string
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }

    /**
     * @param string $pageSize
     * @return LinkPaymentListResponse
     */
    public function setPageSize($pageSize)
    {
        $this->pageSize = $pageSize;
        return $this;
    }

    /**
     * @return string
     */
    public function getPageCount()
    {
        return $this->pageCount;
    }

    /**
     * @param string $pageCount
     * @return LinkPaymentListResponse
     */
    public function setPageCount($pageCount)
    {
        $this->pageCount = $pageCount;
        return $this;
    }

    /**
     * @return array|PaymentLinkRecord[]
     */
    public function getPaymentLinkRecords()
    {
        return $this->paymentLinkRecords;
    }

    /**
     * @param array|PaymentLinkRecord[] $paymentLinkRecords
     * @return LinkPaymentListResponse
     */
    public function setPaymentLinkRecords($paymentLinkRecords)
    {
        $this->paymentLinkRecords = $paymentLinkRecords;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * @param object $object
     * @return LinkPaymentListResponse
     */
    public static function fromObject($object){
        $res = new static();

        if(isset($object->pageIndex)){
            $res->pageIndex = $object->pageIndex;
        }

        if(isset($object->pageSize)){
            $res->pageSize = $object->pageSize;
        }

        if(isset($object->pageCount)){
            $res->pageCount  = $object->pageCount;
        }

        if(isset($object->paymentLinkRecords) && is_array($object->paymentLinkRecords)){
            foreach($object->paymentLinkRecords as $record){
                $res->paymentLinkRecords[] = PaymentLinkRecord::fromObject($record);
            }
        }


        $res->fillFromObject($object);
        return $res;
    }

    #endregion statics

}