<?php


namespace Ysb\IPara\Response;


use Ysb\IPara\Base;

class BaseResponse extends Base
{

    #region fields
    /** @var string */
    protected $result;

    /** @var string */
    protected $errorCode;

    /** @var string */
    protected $errorMessage;

    /** @var string */
    protected $responseMessage;

    /** @var string */
    protected $mode;

    /** @var string */
    protected $echo;

    /** @var string */
    protected $hash;

    /** @var string */
    protected $transactionDate;

    #endregion fields

    #region Properties

    /**
     * @return string
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @param string $result
     * @return static
     */
    public function setResult($result)
    {
        $this->result = $result;
        return $this;
    }

    /**
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }

    /**
     * @param string $errorCode
     * @return static
     */
    public function setErrorCode($errorCode)
    {
        $this->errorCode = $errorCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }

    /**
     * @param string $errorMessage
     * @return static
     */
    public function setErrorMessage($errorMessage)
    {
        $this->errorMessage = $errorMessage;
        return $this;
    }

    /**
     * @return string
     */
    public function getResponseMessage()
    {
        return $this->responseMessage;
    }

    /**
     * @param string $responseMessage
     * @return static
     */
    public function setResponseMessage($responseMessage)
    {
        $this->responseMessage = $responseMessage;
        return $this;
    }

    /**
     * @return string
     */
    public function getMode()
    {
        return $this->mode;
    }

    /**
     * @param string $mode
     * @return static
     */
    public function setMode($mode)
    {
        $this->mode = $mode;
        return $this;
    }

    /**
     * @return string
     */
    public function getEcho()
    {
        return $this->echo;
    }

    /**
     * @param string $echo
     * @return static
     */
    public function setEcho($echo)
    {
        $this->echo = $echo;
        return $this;
    }

    /**
     * @return string
     */
    public function getHash()
    {
        return $this->hash;
    }

    /**
     * @param string $hash
     * @return static
     */
    public function setHash($hash)
    {
        $this->hash = $hash;
        return $this;
    }

    /**
     * @return string
     */
    public function getTransactionDate()
    {
        return $this->transactionDate;
    }

    /**
     * @param string $transactionDate
     * @return static
     */
    public function setTransactionDate($transactionDate)
    {
        $this->transactionDate = $transactionDate;
        return $this;
    }

    #endregion Properties

    #region utils

    /**
     * @param \SimpleXMLElement|object $element
     */
    protected function fillFromObject($element){
        if(isset($element->result)){
            $this->setResult(strval($element->result));
        }
        if(isset($element->errorCode)){
            $this->setErrorCode(strval($element->errorCode));
        }
        if(isset($element->errorMessage)){
            $this->setErrorMessage(strval($element->errorMessage));
        }
        if(isset($element->responseMessage)){
            $this->setResponseMessage(strval($element->responseMessage));
        }
        if(isset($element->mode)){
            $this->setMode(strval($element->mode));
        }
        if(isset($element->echo)){
            $this->setEcho(strval($element->echo));
        }
        if(isset($element->hash)){
            $this->setHash(strval($element->hash));
        }
        if(isset($element->transactionDate)){
            $this->setTransactionDate(strval($element->transactionDate));
        }
    }

    #endregion utils

}
