<?php


namespace Ysb\IPara\Request;


use Ysb\IPara\Entities\Product;
use Ysb\IPara\Entities\Purchaser;
use Ysb\IPara\Helpers\Xml\XmlNode;
use Ysb\IPara\Helpers\Xml\IToXmlNode;


class ThreeDPaymentCompleteRequest  extends  BaseRequest implements IToXmlNode
{
    #region fields
    /** @var string */
    protected $threeD;

    /** @var string */
    protected $orderId;

    /** @var string */
    protected $amount;

    /** @var string */
    protected $cardOwnerName;

    /** @var string */
    protected $cardNumber;

    /** @var string */
    protected $cardExpireMonth;

    /** @var string */
    protected $cardExpireYear;

    /** @var string */
    protected $installment;

    /** @var string */
    protected $cvc;

    /** @var string */
    protected $vendorId;

    /** @var string */
    protected $userId;

    /** @var string */
    protected $cardId;

    /** @var string */
    protected $threeDSecureCode;

    /** @var array|Product[] */
    protected $products = array();

    /** @var Purchaser */
    protected $purchaser;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getThreeD()
    {
        return $this->threeD;
    }

    /**
     * @param string $threeD
     * @return ThreeDPaymentCompleteRequest
     */
    public function setThreeD($threeD)
    {
        $this->threeD = $threeD;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param string $orderId
     * @return ThreeDPaymentCompleteRequest
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
        return $this;
    }

    /**
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param string $amount
     * @return ThreeDPaymentCompleteRequest
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardOwnerName()
    {
        return $this->cardOwnerName;
    }

    /**
     * @param string $cardOwnerName
     * @return ThreeDPaymentCompleteRequest
     */
    public function setCardOwnerName($cardOwnerName)
    {
        $this->cardOwnerName = $cardOwnerName;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardNumber()
    {
        return $this->cardNumber;
    }

    /**
     * @param string $cardNumber
     * @return ThreeDPaymentCompleteRequest
     */
    public function setCardNumber($cardNumber)
    {
        $this->cardNumber = $cardNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardExpireMonth()
    {
        return $this->cardExpireMonth;
    }

    /**
     * @param string $cardExpireMonth
     * @return ThreeDPaymentCompleteRequest
     */
    public function setCardExpireMonth($cardExpireMonth)
    {
        $this->cardExpireMonth = $cardExpireMonth;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardExpireYear()
    {
        return $this->cardExpireYear;
    }

    /**
     * @param string $cardExpireYear
     * @return ThreeDPaymentCompleteRequest
     */
    public function setCardExpireYear($cardExpireYear)
    {
        $this->cardExpireYear = $cardExpireYear;
        return $this;
    }

    /**
     * @return string
     */
    public function getInstallment()
    {
        return $this->installment;
    }

    /**
     * @param string $installment
     * @return ThreeDPaymentCompleteRequest
     */
    public function setInstallment($installment)
    {
        $this->installment = $installment;
        return $this;
    }

    /**
     * @return string
     */
    public function getCvc()
    {
        return $this->cvc;
    }

    /**
     * @param string $cvc
     * @return ThreeDPaymentCompleteRequest
     */
    public function setCvc($cvc)
    {
        $this->cvc = $cvc;
        return $this;
    }

    /**
     * @return string
     */
    public function getVendorId()
    {
        return $this->vendorId;
    }

    /**
     * @param string $vendorId
     * @return ThreeDPaymentCompleteRequest
     */
    public function setVendorId($vendorId)
    {
        $this->vendorId = $vendorId;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param string $userId
     * @return ThreeDPaymentCompleteRequest
     */
    public function setUserId($userId)
    {
        $this->userId = $userId;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardId()
    {
        return $this->cardId;
    }

    /**
     * @param string $cardId
     * @return ThreeDPaymentCompleteRequest
     */
    public function setCardId($cardId)
    {
        $this->cardId = $cardId;
        return $this;
    }

    /**
     * @return string
     */
    public function getThreeDSecureCode()
    {
        return $this->threeDSecureCode;
    }

    /**
     * @param string $threeDSecureCode
     * @return ThreeDPaymentCompleteRequest
     */
    public function setThreeDSecureCode($threeDSecureCode)
    {
        $this->threeDSecureCode = $threeDSecureCode;
        return $this;
    }

    /**
     * @return array|Product[]
     */
    public function getProducts()
    {
        return $this->products;
    }

    /**
     * @param array|Product[] $products
     * @return ThreeDPaymentCompleteRequest
     */
    public function setProducts($products)
    {
        $this->products = $products;
        return $this;
    }

    /**
     * @return Purchaser
     */
    public function getPurchaser()
    {
        return $this->purchaser;
    }

    /**
     * @param Purchaser $purchaser
     * @return ThreeDPaymentCompleteRequest
     */
    public function setPurchaser($purchaser)
    {
        $this->purchaser = $purchaser;
        return $this;
    }

    #endregion properties

    #region methods

    /**
     * @param Product $product
     * @return $this
     */
    public function addProduct($product){
        $this->products[] = $product;
        return $this;
    }

    #endregion methods

    #region IToXmlNode

    /**
     * @param bool $root
     * @return XmlNode
     */
    public function toXmlNode($root = false)
    {
        $node = (new XmlNode('auth'))
            ->setRoot($root)
            ->addChild(new XmlNode('threeD', $this->threeD))
            ->addChild(new XmlNode('orderId', $this->orderId))
            ->addChild(new XmlNode('amount', $this->amount))
            ->addChild(new XmlNode('cardOwnerName', urlencode($this->cardOwnerName)))
            ->addChild(new XmlNode('cardNumber', $this->cardNumber))
            ->addChild(new XmlNode('cardExpireMonth', $this->cardExpireMonth))
            ->addChild(new XmlNode('cardExpireYear', $this->cardExpireYear))
            ->addChild(new XmlNode('installment', $this->installment))
            ->addChild(new XmlNode('cardCvc', $this->cvc))
            ->addChild(new XmlNode('userId', $this->userId))
            ->addChild(new XmlNode('cardId', $this->cardId))
            ->addChild(new XmlNode('mode', $this->mode));
        if($this->getThreeD()){
            $node->addChild(new XmlNode('threeDSecureCode',$this->threeDSecureCode));
        }
        if($this->getVendorId()){
            $node->addChild(new XmlNode('vendorId',$this->vendorId));
        }

        $products = new XmlNode('products');
        if(!empty($this->getProducts())){
            foreach ($this->getProducts() as $product){
                $products->addChild($product->toXmlNode(false));
            }
        }
        $node->addChild($products);
        if($this->getPurchaser()){
            $purchaser = $this->getPurchaser()->toXmlNode(false);

        }else{
            $purchaser = new XmlNode('purchaser');
        }
        $node->addChild($purchaser);

        return $node;

    }

    /**
     * @param bool $useIndent
     * @param int $indentLevel
     * @param string $indentChars
     * @return string
     */
    public function toXmlString($useIndent = false, $indentLevel = 0, $indentChars = '    ')
    {
        return $this->toXmlNode(true)
            ->toXmlString($useIndent,$indentLevel,$indentChars);
    }

    #endregion IToXmlNode

}