<?php


namespace Ysb\IPara\Request;



use Ysb\IPara\Helpers\Xml\XmlNode;
use Ysb\IPara\Helpers\Xml\IToXmlNode;


class PaymentInquiryRequest extends BaseRequest implements IToXmlNode
{

    #region fields

    /** @var string */
    protected $orderId;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param string $orderId
     * @return PaymentInquiryRequest
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
        return $this;
    }

    #endregion properties

    #region IToXmlNode


    /**
     * @param bool $root
     * @return XmlNode
     */
    public function toXmlNode($root = false)
    {
        $node = (new XmlNode('inquiry'))
            ->setRoot($root)
            ->addChild(new XmlNode('orderId', $this->orderId))
            ->addChild(new XmlNode('echo', $this->echo))
            ->addChild(new XmlNode('mode', $this->mode));
        return $node;
    }

    /**
     * @param bool $useIndent
     * @param int $indentLevel
     * @param string $indentChars
     * @return string
     */
    public function toXmlString($useIndent = false, $indentLevel = 0, $indentChars = '    ')
    {
        return $this->toXmlNode(true)
            ->toXmlString($useIndent, $indentLevel, $indentChars);
    }

    #endregion IToXmlNode


}