<?php


namespace Ysb\IPara\Request;



class Api3DPaymentRequest extends ApiPaymentRequest
{
    #region fields

    /**
     * @var string
     */
    protected $successUrl;

    /**
     * @var string
     */
    protected $failUrl;

    /**
     * @var string
     */
    protected $transactionDate;

    /**
     * @var string
     */
    protected $deviceUUID;

    /**
     * @var string
     */
    protected $token;

    /**
     * @var string
     */
    protected $language = "tr-TR";

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getSuccessUrl()
    {
        return $this->successUrl;
    }

    /**
     * @param string $successUrl
     * @return Api3DPaymentRequest
     */
    public function setSuccessUrl($successUrl)
    {
        $this->successUrl = $successUrl;
        return $this;
    }

    /**
     * @return string
     */
    public function getFailUrl()
    {
        return $this->failUrl;
    }

    /**
     * @param string $failUrl
     * @return Api3DPaymentRequest
     */
    public function setFailUrl($failUrl)
    {
        $this->failUrl = $failUrl;
        return $this;
    }

    /**
     * @return string
     */
    public function getTransactionDate()
    {
        return $this->transactionDate;
    }

    /**
     * @param string $transactionDate
     * @return Api3DPaymentRequest
     */
    public function setTransactionDate($transactionDate)
    {
        $this->transactionDate = $transactionDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getDeviceUUID()
    {
        return $this->deviceUUID;
    }

    /**
     * @param string $deviceUUID
     * @return Api3DPaymentRequest
     */
    public function setDeviceUUID($deviceUUID)
    {
        $this->deviceUUID = $deviceUUID;
        return $this;
    }

    /**
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * @param string $token
     * @return Api3DPaymentRequest
     */
    public function setToken($token)
    {
        $this->token = $token;
        return $this;
    }

    /**
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * @param string $language
     * @return Api3DPaymentRequest
     */
    public function setLanguage($language)
    {
        $this->language = $language;
        return $this;
    }

    #endregion properties

    /*

    public function toJsonString(Settings $settings)
    {
        $purchaser = [
            "name" => $this->purchaser->getName(),
            "surname" => $this->purchaser->getSurname(),
            "email" => $this->purchaser->getEmail(),
            "clientIp" => $this->purchaser->getClientIp(),
            "birthDate" => $this->purchaser->getBirthDate(),
            "gsmNumber" => $this->purchaser->getGsmPhone(),
            "tcCertificate" => $this->purchaser->getIdentityNumber(),
            "invoiceAddress" => [
                "name" => $this->purchaser->getInvoiceAddress()->getName(),
                "surname" => $this->purchaser->getInvoiceAddress()->getSurname(),
                "address" => $this->purchaser->getInvoiceAddress()->getAddress(),
                "zipcode" => $this->purchaser->getInvoiceAddress()->getZipCode(),
                "city" => $this->purchaser->getInvoiceAddress()->getCityCode(),
                "country" => $this->purchaser->getInvoiceAddress()->getCountryCode(),
                "tcCertificate" => $this->purchaser->getInvoiceAddress()->getIdentityNumber(),
                "taxNumber" => $this->purchaser->getInvoiceAddress()->getTaxNumber(),
                "taxOffice" => $this->purchaser->getInvoiceAddress()->getTaxOffice(),
                "companyName" => $this->purchaser->getInvoiceAddress()->getCountryCode(),
                "phoneNumber" => $this->purchaser->getInvoiceAddress()->getPhoneNumber()
            ],
            "shippingAddress" => [
                "name" => $this->Purchaser->ShippingAddress->Name,
                "surname" => $this->Purchaser->ShippingAddress->SurName,
                "address" => $this->Purchaser->ShippingAddress->Address,
                "zipcode" => $this->Purchaser->ShippingAddress->ZipCode,
                "city" => $this->Purchaser->ShippingAddress->CityCode,
                "country" => $this->Purchaser->ShippingAddress->CountryCode,
                "tcCertificate" => $this->Purchaser->ShippingAddress->IdentityNumber,
                "phoneNumber" => $this->Purchaser->ShippingAddress->PhoneNumber
            ]
        ];

        $products = [];
        foreach($this->Products as $product) {
            $tmp['productCode'] = $product->Code;
            $tmp['productName'] = $product->Title;
            $tmp['quantity'] = $product->Quantity;
            $tmp['price'] = $product->Price;
            $products[] = $tmp;
        }

        $paymentRequest = [
            "mode" => $settings->Mode,
            "orderId" => $this->OrderId,
            "cardOwnerName" => $this->CardOwnerName,
            "cardNumber" => $this->CardNumber,
            "cardExpireMonth" => $this->CardExpireMonth,
            "cardExpireYear" => $this->CardExpireYear,
            "cardCvc" => $this->Cvc,
            "userId" => $this->UserId,
            "cardId" => $this->CardId,
            "installment" => $this->Installment,
            "amount" => $this->Amount,
            "echo" => $this->Echo,
            "successUrl" => $this->successUrl,
            "failureUrl" => $this->failUrl,
            "transactionDate" => $settings->transactionDate,
            "version" => $settings->Version,
            "token" => $this->token,
            "language" => $this->language,
            "purchaser" => $purchaser,
            "products" => $products
        ];

        return json_encode($paymentRequest);
    }
*/

    public function toHtmlString($parameters, $url) {
        $builder = "";

        $builder .= "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">";
        $builder .= "<html>";
        $builder .= "<body>";
        $builder .= "<form action=\"" . $url . "\" method=\"post\" id=\"three_d_form\" >";
        $builder .= "<input type=\"hidden\" name=\"parameters\" value=\"" . htmlspecialchars($parameters) . "\"/>";
        $builder .= "<input type=\"submit\" value=\"Öde\" style=\"display:none;\"/>";
        $builder .= "<noscript>";
        $builder .= "<br/>";
        $builder .= "<br/>";
        $builder .= "<center>";
        $builder .= "<h1>3D Secure Yönlendirme İşlemi</h1>";
        $builder .= "<h2>Javascript internet tarayıcınızda kapatılmış veya desteklenmiyor.<br/></h2>";
        $builder .= "<h3>Lütfen banka 3D Secure sayfasına yönlenmek için tıklayınız.</h3>";
        $builder .= "<input type=\"submit\" value=\"3D Secure Sayfasına Yönlen\">";
        $builder .= "</center>";
        $builder .= "</noscript>";
        $builder .= "</form>";
        $builder .= "</body>";
        $builder .= "<script>document.getElementById(\"three_d_form\").submit();</script>";
        $builder .= "</html>";
        return $builder;
    }
}