<?php


namespace Ysb\IPara;


use SimpleXMLElement;
use Ysb\IPara\Helpers\Helper;
use Ysb\IPara\Request\ApiPaymentRequest;
use Ysb\IPara\Request\BankCardCreateRequest;
use Ysb\IPara\Request\BankCardDeleteRequest;
use Ysb\IPara\Request\BankCardInquiryRequest;
use Ysb\IPara\Request\BinNumberInquiryRequest;
use Ysb\IPara\Request\LinkPaymentCreateRequest;
use Ysb\IPara\Request\LinkPaymentListRequest;
use Ysb\IPara\Request\PaymentInquiryRequest;
use Ysb\IPara\Request\ThreeDPaymentCompleteRequest;
use Ysb\IPara\Request\ThreeDPaymentInitRequest;
use Ysb\IPara\Response\ApiPaymentResponse;
use Ysb\IPara\Response\BankCardCreateResponse;
use Ysb\IPara\Response\BankCardDeleteResponse;
use Ysb\IPara\Response\BankCardInquryResponse;
use Ysb\IPara\Response\BinNumberInquiryResponse;
use Ysb\IPara\Response\LinkPaymentCreateResponse;
use Ysb\IPara\Response\LinkPaymentListResponse;
use Ysb\IPara\Response\PaymentInquiryResponse;
use Ysb\IPara\Response\ThreeDPaymentCompleteResponse;
use Ysb\IPara\Response\ThreeDPaymentInitResponse;

class IParaClient
{

    #region fields

    /** @var Settings */
    protected $settings;

    #endregion fields

    #region ctor
    /**
     * IParaClient constructor.
     * @param Settings $settings
     */
    public function __construct($settings)
    {
        $this->settings = $settings;
    }

    #endregion ctor

    #region properties

    /**
     * @return Settings
     */
    public function getSettings()
    {
        return $this->settings;
    }

    /**
     * @param Settings $settings
     * @return IParaClient
     */
    public function setSettings($settings)
    {
        $this->settings = $settings;
        return $this;
    }


    #endregion properties

    #region methods

    /**
     * (Non-3d) Ödeme
     *
     * @param ApiPaymentRequest $request
     * @return ApiPaymentResponse
     */
    public function payment($request)
    {
        $settings = $this->getSettings();
        $settings->setTransactionDate(Helper::GetTransactionDateString());
        $request->setMode($settings->getMode());

        $hashString = $settings->getPrivateKey() . $request->getOrderId() . $request->getAmount() . $request->getMode() . $request->getCardOwnerName() . $request->getCardNumber() . $request->getCardExpireMonth() . $request->getCardExpireYear() . $request->getCvc() . $request->getUserId() . $request->getCardId() . $request->getPurchaser()->getName() . $request->getPurchaser()->getSurname() . $request->getPurchaser()->getEmail() . $settings->getTransactionDate();
        $settings->setHashString($hashString);
        $xmlRes = RestHttpCaller::post($settings->getBaseUrl() . "rest/payment/auth", Helper::GetHttpHeaders($settings, "application/xml"), $request->toXmlString(false));
        //var_dump($xmlRes);
        $root = new SimpleXMLElement($xmlRes);
        $response = ApiPaymentResponse::fromSimpleXml($root);
        return $response;
    }

    /**
     * Cüzdana Kart Ekleme
     *
     * @param BankCardCreateRequest $request
     * @return BankCardCreateResponse
     */
    public function bankCardCreate($request)
    {
        $settings = $this->getSettings();
        $settings->setTransactionDate(Helper::GetTransactionDateString());
        $request->setMode($settings->getMode());
        $hashString = $settings->getPrivateKey() . $request->getUserId() .
            $request->getCardOwnerName() . $request->getCardNumber() .
            $request->getCardExpireMonth() . $request->getCardExpireYear() .
            $request->getClientIp() . $settings->getTransactionDate();
        $settings->setHashString($hashString);
        $res = RestHttpCaller::post($settings->getBaseUrl() . "bankcard/create", Helper::GetHttpHeaders($settings, "application/json"), json_encode($request));
        $resObj = json_decode($res);
        return BankCardCreateResponse::fromObject($resObj);
    }

    /**
     * Cüzdandan Kart Sil
     *
     * @param BankCardDeleteRequest $request
     * @return BankCardDeleteResponse
     */
    public function bankCardDelete($request)
    {
        $settings = $this->settings;
        $settings->setTransactionDate(Helper::GetTransactionDateString());
        $request->setMode($settings->getMode());
        $hashString = $settings->getPrivateKey() . $request->getUserId() .
            $request->getCardId() . $request->getClientIp() .
            $settings->getTransactionDate();
        $settings->setHashString($hashString);
        $res = restHttpCaller::post($settings->getBaseUrl() . "bankcard/delete", Helper::GetHttpHeaders($settings, "application/json"), json_encode($request));
        $res = json_decode($res);
        return BankCardDeleteResponse::fromObject($res);
    }

    /**
     * Cüzdandaki Kartları Getir
     *
     * @param BankCardInquiryRequest $request
     * @return BankCardInquryResponse
     */
    public function bankCardInquiry($request)
    {
        $request->setClientIp(Helper::get_client_ip());
        $settings = $this->settings;
        $request->setMode($settings->getMode());
        $settings->setTransactionDate(Helper::GetTransactionDateString());
        $hashString = $settings->getPrivateKey() . $request->getUserId() .
            $request->getCardId() . $request->getClientIp() . $settings->getTransactionDate();
        $settings->setHashString($hashString);
        $res = RestHttpCaller::post($settings->getBaseUrl() . "bankcard/inquiry", Helper::GetHttpHeaders($settings, "application/json"), json_encode($request));
        $res = json_decode($res);
        return BankCardInquryResponse::fromObject($res);
    }

    /**
     * Bin Sorgulama
     *
     * @param BinNumberInquiryRequest $request
     * @return BinNumberInquiryResponse
     */
    public function binNumberInquiry($request)
    {
        $settings = $this->settings;
        $settings->setTransactionDate(Helper::GetTransactionDateString());
        $request->setMode($settings->getMode());
        $hashString = $settings->getPrivateKey() . $request->getBinNumber() .
            $settings->getTransactionDate();
        $settings->setHashString($hashString);
        $res = RestHttpCaller::post($settings->getBaseUrl() . "rest/payment/bin/lookup", Helper::GetHttpHeaders($settings, "application/json"), json_encode($request));
        $res = json_decode($res);
        return BinNumberInquiryResponse::fromObject($res);
    }


    /**
     * Ödeme Sorgulama
     *
     * @param PaymentInquiryRequest $request
     * @return PaymentInquiryResponse
     */
    public function paymentInquiry($request)
    {
        $settings = $this->settings;
        $settings->setTransactionDate(Helper::GetTransactionDateString());
        $request->setMode($settings->getMode());
        $hashString = $settings->getPrivateKey() . $request->getOrderId() .
            $request->getMode() . $settings->getTransactionDate();
        $settings->setHashString($hashString);
        $res = RestHttpCaller::post($settings->getBaseUrl() . "rest/payment/inquiry", Helper::GetHttpHeaders($settings, "application/xml"), $request->toXmlString(false));
        $res = new SimpleXMLElement($res);
        return PaymentInquiryResponse::fromObject($res);
    }

    /**
     * 3D Secure ile Ödeme (1. request)
     *
     * @param ThreeDPaymentInitRequest $request
     * @return string html
     */
    public function threeDPaymentInit($request)
    {
        $settings = $this->settings;
        $settings->setTransactionDate(Helper::GetTransactionDateString());
        $request->setMode($settings->getMode());
        $request->setTransactionDate($settings->getTransactionDate());
        $request->setVersion($settings->getVersion());
        $hashString = $settings->getPrivateKey() . $request->getOrderId() .
            $request->getAmount() . $request->getMode() . $request->getCardOwnerName() .
            $request->getCardNumber() . $request->getCardExpireMonth() .
            $request->getCardExpireYear() . $request->getCvc() . $request->getUserId() .
            $request->getCardId() . $request->getPurchaserName() . $request->getPurchaserSurname()
            . $request->getPurchaserEmail() . $settings->getTransactionDate();
        $settings->setHashString($hashString);
        $token = Helper::CreateToken($settings->getPublicKey(), $settings->getHashString());
        $request->setToken($token);
        return $request->toHtmlString($settings);
    }

    /**
     * 3D Secure ile Ödeme (1. response)
     *
     * @param array $postArray
     * @return ThreeDPaymentInitResponse|bool
     */
    public function threeDPaymentInitResponse($postArray, &$error = '')
    {
        $response =  ThreeDPaymentInitResponse::fromPostArray($postArray);

        if(! Helper::validate3DReturn($response,$this->settings,$error,false)){
            return false;
        }
        return $response;
    }

    /**
     * 3D Secure ile Ödeme (2. request)
     *
     * @param ThreeDPaymentCompleteRequest $request
     * @return ThreeDPaymentCompleteResponse 3D Secure ile Ödeme (2. response)
     */
    public function threeDPaymentComplete($request)
    {
        $settings = $this->settings;
        $settings->setTransactionDate(Helper::GetTransactionDateString());
        $request->setMode($settings->getMode());
        $hashString = $settings->getPrivateKey() . $request->getOrderId() .
            $request->getAmount() . $request->getMode() . $request->getThreeDSecureCode() .
            $settings->getTransactionDate();
        $settings->setHashString($hashString);
        $res = RestHttpCaller::post($settings->getBaseUrl() . "rest/payment/auth", Helper::GetHttpHeaders($settings, "application/xml"), $request->toXmlString(false));
        $res = new SimpleXMLElement($res);
        return ThreeDPaymentCompleteResponse::fromObject($res);
    }


    /**
     * Link İle Ödeme (Link Gönderim)
     *
     * @param LinkPaymentCreateRequest $request
     * @return LinkPaymentCreateResponse
     */
    public function linkPaymentCreate($request)
    {
        $settings = $this->settings;
        $request->setMode($settings->getMode());
        if (!$request->getClientIp()) {
            $request->setClientIp(Helper::get_client_ip());
        }
        $settings->setTransactionDate(Helper::GetTransactionDateString());
        $hashString = $settings->getPrivateKey() . $request->getName() .
            $request->getSurname() . $request->getEmail() . $request->getAmount() .
            $request->getClientIp() . $settings->getTransactionDate();
        $settings->setHashString($hashString);

        $res = RestHttpCaller::post($settings->getBaseUrl() . "corporate/merchant/linkpayment/create", Helper::GetHttpHeaders($settings, "application/json"), json_encode($request));
        $res = json_decode($res);
        return LinkPaymentCreateResponse::fromObject($res);

    }

    /**
     * Link İle Ödeme (Link Sorgulama)
     *
     * @param LinkPaymentListRequest $request
     * @return LinkPaymentListResponse
     */
    public function linkPaymentList($request)
    {
        $settings = $this->settings;
        $request->setMode($this->settings->getMode());
        if(! $request->getClientIp()){
            $request->setClientIp(Helper::get_client_ip());
        }
        $settings->setTransactionDate(Helper::GetTransactionDateString());

        $hashString = $settings->getPrivateKey() . $request->getClientIp() .
            $settings->getTransactionDate();
        $settings->setHashString($hashString);

        $res = RestHttpCaller::post($settings->getBaseUrl() . "corporate/merchant/linkpayment/list", Helper::GetHttpHeaders($settings, "application/json"), json_encode($request));
        $res = json_decode($res);
        return LinkPaymentListResponse::fromObject($res);
    }

    #endregion methods

}
