<?php


namespace Ysb\IPara\Response;


class ThreeDPaymentCompleteResponse extends BaseResponse
{
    #region fields

    /** @var string */
    protected $amount;

    /** @var string */
    protected $orderId;

    /** @var string */
    protected $publicKey;


    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param string $amount
     * @return $this
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param string $orderId
     * @return $this
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
        return $this;
    }

    /**
     * @return string
     */
    public function getPublicKey()
    {
        return $this->publicKey;
    }

    /**
     * @param string $publicKey
     * @return ThreeDPaymentCompleteResponse
     */
    public function setPublicKey($publicKey)
    {
        $this->publicKey = $publicKey;
        return $this;
    }

    #endregion properties

    #region static

    /**
     * @param object|\SimpleXMLElement $object
     * @return ThreeDPaymentCompleteResponse
     */
    public static function fromObject($object){
        $res = new static();

        if(isset($object->amount)){
            $res->amount = $object->amount;
        }

        if(isset($object->orderId)){
            $res->orderId = $object->orderId;
        }

        if(isset($object->publicKey)){
            $res->publicKey = $object->publicKey;
        }

        $res->fillFromObject($object);
        return $res;
    }

    #endregion static
}