<?php


namespace Ysb\IPara\Response;


class PaymentInquiryResponse extends BaseResponse
{
    #region fields

    /** @var string */
    protected $amount;

    /** @var string */
    protected $orderId;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param string $amount
     * @return PaymentInquiryResponse
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param string $orderId
     * @return PaymentInquiryResponse
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * @param object|\SimpleXMLElement $object
     * @return PaymentInquiryResponse
     */
    public static function fromObject($object)
    {
        $res = new static();

        if (isset($object->amount)) {
            $res->amount = $object->amount;
        }

        if (isset($object->orderId)) {
            $res->orderId = $object->orderId;
        }

        $res->fillFromObject($object);
        return $res;
    }

    #endregion statics

}