<?php


namespace Ysb\IPara\Response;


class BinNumberInquiryResponse extends BaseResponse
{
    #region fields
    /** @var string */
    protected $bankId;

    /** @var string */
    protected $bankName;

    /** @var string */
    protected $cardFamilyName;

    /** @var string */
    protected $supportsInstallment;

    /** @var array|string[] */
    protected $supportedInstallments;

    /** @var string */
    protected $type;

    /** @var string */
    protected $serviceProvider;

    /** @var string */
    protected $cardThreeDSecureMandatory;

    /** @var string */
    protected $merchantThreeDSecureMandatory;

    /** @var string */
    protected $cvcMandatory;

    /** @var string */
    protected $businessCard;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getBankId()
    {
        return $this->bankId;
    }

    /**
     * @param string $bankId
     * @return BinNumberInquiryResponse
     */
    public function setBankId($bankId)
    {
        $this->bankId = $bankId;
        return $this;
    }

    /**
     * @return string
     */
    public function getBankName()
    {
        return $this->bankName;
    }

    /**
     * @param string $bankName
     * @return BinNumberInquiryResponse
     */
    public function setBankName($bankName)
    {
        $this->bankName = $bankName;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardFamilyName()
    {
        return $this->cardFamilyName;
    }

    /**
     * @param string $cardFamilyName
     * @return BinNumberInquiryResponse
     */
    public function setCardFamilyName($cardFamilyName)
    {
        $this->cardFamilyName = $cardFamilyName;
        return $this;
    }

    /**
     * @return string
     */
    public function getSupportsInstallment()
    {
        return $this->supportsInstallment;
    }

    /**
     * @param string $supportsInstallment
     * @return BinNumberInquiryResponse
     */
    public function setSupportsInstallment($supportsInstallment)
    {
        $this->supportsInstallment = $supportsInstallment;
        return $this;
    }

    /**
     * @return array|string[]
     */
    public function getSupportedInstallments()
    {
        return $this->supportedInstallments;
    }

    /**
     * @param array|string[] $supportedInstallments
     * @return BinNumberInquiryResponse
     */
    public function setSupportedInstallments($supportedInstallments)
    {
        $this->supportedInstallments = $supportedInstallments;
        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return BinNumberInquiryResponse
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return string
     */
    public function getServiceProvider()
    {
        return $this->serviceProvider;
    }

    /**
     * @param string $serviceProvider
     * @return BinNumberInquiryResponse
     */
    public function setServiceProvider($serviceProvider)
    {
        $this->serviceProvider = $serviceProvider;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardThreeDSecureMandatory()
    {
        return $this->cardThreeDSecureMandatory;
    }

    /**
     * @param string $cardThreeDSecureMandatory
     * @return BinNumberInquiryResponse
     */
    public function setCardThreeDSecureMandatory($cardThreeDSecureMandatory)
    {
        $this->cardThreeDSecureMandatory = $cardThreeDSecureMandatory;
        return $this;
    }

    /**
     * @return string
     */
    public function getMerchantThreeDSecureMandatory()
    {
        return $this->merchantThreeDSecureMandatory;
    }

    /**
     * @param string $merchantThreeDSecureMandatory
     * @return BinNumberInquiryResponse
     */
    public function setMerchantThreeDSecureMandatory($merchantThreeDSecureMandatory)
    {
        $this->merchantThreeDSecureMandatory = $merchantThreeDSecureMandatory;
        return $this;
    }

    /**
     * @return string
     */
    public function getCvcMandatory()
    {
        return $this->cvcMandatory;
    }

    /**
     * @param string $cvcMandatory
     * @return BinNumberInquiryResponse
     */
    public function setCvcMandatory($cvcMandatory)
    {
        $this->cvcMandatory = $cvcMandatory;
        return $this;
    }

    /**
     * @return string
     */
    public function getBusinessCard()
    {
        return $this->businessCard;
    }

    /**
     * @param string $businessCard
     * @return BinNumberInquiryResponse
     */
    public function setBusinessCard($businessCard)
    {
        $this->businessCard = $businessCard;
        return $this;
    }

    #endregion properties

    #region statics

    public static function fromObject($object){
        $res = new static();

        if(isset($object->bankId)){
            $res->bankId = $object->bankId;
        }

        if(isset($object->bankName)){
            $res->bankName = $object->bankName;
        }

        if(isset($object->cardFamilyName)){
            $res->cardFamilyName = $object->cardFamilyName;
        }

        if(isset($object->supportsInstallment)){
            $res->supportsInstallment = $object->supportsInstallment;
        }

        if(isset($object->supportedInstallments) && is_array($object->supportedInstallments)){
            $res->supportedInstallments = $object->supportedInstallments;
        }

        if(isset($object->type)){
            $res->type = $object->type;
        }

        if(isset($object->serviceProvider)){
            $res->serviceProvider = $object->serviceProvider;
        }
        if(isset($object->cardThreeDSecureMandatory)){
            $res->cardThreeDSecureMandatory = $object->cardThreeDSecureMandatory;
        }

        if(isset($object->merchantThreeDSecureMandatory)){
            $res->merchantThreeDSecureMandatory = $object->merchantThreeDSecureMandatory;
        }

        if(isset($object->cvcMandatory)){
            $res->cvcMandatory = $object->cvcMandatory;
        }
        if(isset($object->businessCard)){
            $res->businessCard = $object->businessCard;
        }

        $res->fillFromObject($object);

        return $res;
    }

    #endregion statics

}