<?php


namespace Ysb\IPara\Response;


class ApiPaymentResponse extends BaseResponse
{

    #region fields

    /** @var string */
    protected $amount;

    /** @var string */
    protected $orderId;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param string $amount
     * @return ApiPaymentResponse
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param string $orderId
     * @return ApiPaymentResponse
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * @param \SimpleXMLElement|object $element
     * @return $this
     */
    public static function fromSimpleXml($element)
    {
        $res = new static();

        if(isset($element->amount)){
            $res->setAmount(strval($element->amount));
        }

        if(isset($element->orderId)){
            $res->setOrderId(strval($element->orderId));
        }
        $res->fillFromObject($element);
        return $res;

    }

    #endregion statics


}
