<?php


namespace Ysb\IPara\Request;


use JsonSerializable;

class LinkPaymentListRequest extends BaseRequest implements JsonSerializable
{
    #region fields


    /** @var string */
    protected $startDate;

    /** @var string */
    protected $endDate;

    /** @var string */
    protected $pageSize;

    /** @var string */
    protected $pageIndex;

    /** @var string */
    protected $clientIp;

    /** @var string */
    protected $email;

    /** @var string */
    protected $gsm;

    /** @var string */
    protected $linkState;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getStartDate()
    {
        return $this->startDate;
    }

    /**
     * @param string $startDate
     * @return LinkPaymentListRequest
     */
    public function setStartDate($startDate)
    {
        $this->startDate = $startDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getEndDate()
    {
        return $this->endDate;
    }

    /**
     * @param string $endDate
     * @return LinkPaymentListRequest
     */
    public function setEndDate($endDate)
    {
        $this->endDate = $endDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }

    /**
     * @param string $pageSize
     * @return LinkPaymentListRequest
     */
    public function setPageSize($pageSize)
    {
        $this->pageSize = $pageSize;
        return $this;
    }

    /**
     * @return string
     */
    public function getPageIndex()
    {
        return $this->pageIndex;
    }

    /**
     * @param string $pageIndex
     * @return LinkPaymentListRequest
     */
    public function setPageIndex($pageIndex)
    {
        $this->pageIndex = $pageIndex;
        return $this;
    }

    /**
     * @return string
     */
    public function getClientIp()
    {
        return $this->clientIp;
    }

    /**
     * @param string $clientIp
     * @return LinkPaymentListRequest
     */
    public function setClientIp($clientIp)
    {
        $this->clientIp = $clientIp;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return LinkPaymentListRequest
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getGsm()
    {
        return $this->gsm;
    }

    /**
     * @param string $gsm
     * @return LinkPaymentListRequest
     */
    public function setGsm($gsm)
    {
        $this->gsm = $gsm;
        return $this;
    }

    /**
     * @return string
     */
    public function getLinkState()
    {
        return $this->linkState;
    }

    /**
     * @param string $linkState
     * @return LinkPaymentListRequest
     */
    public function setLinkState($linkState)
    {
        $this->linkState = $linkState;
        return $this;
    }

    #endregion properties

    #region JsonSerializable

    /**
     * Specify data which should be serialized to JSON
     * @link https://php.net/manual/en/jsonserializable.jsonserialize.php
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource.
     * @since 5.4.0
     */
    public function jsonSerialize()
    {
        return array(
            "email" => $this->email,
            "gsm" => $this->gsm,
            "linkState" => $this->linkState,
            "startDate" => $this->startDate,
            "endDate" => $this->endDate,
            "pageSize" => $this->pageSize,
            "pageIndex" => $this->pageIndex,
            "clientIp" => $this->clientIp
        );
    }

    #endregion JsonSerializable
}