<?php


namespace Ysb\IPara\Request;


use JsonSerializable;
use Ysb\IPara\Helpers\Helper;
use Ysb\IPara\RestHttpCaller;
use Ysb\IPara\Settings;

class BinNumberInquiryRequest extends BaseRequest implements JsonSerializable
{

    #region fields

    /** @var string */
    protected $binNumber;

    #endregion fields

    #region Properties

    /**
     * @return string
     */
    public function getBinNumber()
    {
        return $this->binNumber;
    }

    /**
     * @param string $binNumber
     * @return BinNumberInquiryRequest
     */
    public function setBinNumber($binNumber)
    {
        $this->binNumber = $binNumber;
        return $this;
    }

    #endregion Properties





    #region JsonSerializable

    /**
     * Specify data which should be serialized to JSON
     * @link https://php.net/manual/en/jsonserializable.jsonserialize.php
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource.
     * @since 5.4.0
     */
    public function jsonSerialize()
    {
        return array(
            "binNumber" => $this->getBinNumber()
        );
    }

    #endregion JsonSerializable

}