<?php


namespace Ysb\IPara\Request;


use JsonSerializable;

class BankCardCreateRequest extends BaseRequest implements JsonSerializable
{

    #region fields
    //Cüzdana kart ekleme servisi içerisinde kullanılacak alanları temsil etmektedir.

    /** @var string */
    protected $userId;

    /** @var string */
    protected $cardOwnerName;

    /** @var string */
    protected $cardNumber;

    /** @var string */
    protected $cardAlias;

    /** @var string */
    protected $cardExpireMonth;

    /** @var string */
    protected $cardExpireYear;

    /** @var string */
    protected $clientIp;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param string $userId
     * @return BankCardCreateRequest
     */
    public function setUserId($userId)
    {
        $this->userId = $userId;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardOwnerName()
    {
        return $this->cardOwnerName;
    }

    /**
     * @param string $cardOwnerName
     * @return BankCardCreateRequest
     */
    public function setCardOwnerName($cardOwnerName)
    {
        $this->cardOwnerName = $cardOwnerName;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardNumber()
    {
        return $this->cardNumber;
    }

    /**
     * @param string $cardNumber
     * @return BankCardCreateRequest
     */
    public function setCardNumber($cardNumber)
    {
        $this->cardNumber = $cardNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardAlias()
    {
        return $this->cardAlias;
    }

    /**
     * @param string $cardAlias
     * @return BankCardCreateRequest
     */
    public function setCardAlias($cardAlias)
    {
        $this->cardAlias = $cardAlias;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardExpireMonth()
    {
        return $this->cardExpireMonth;
    }

    /**
     * @param string $cardExpireMonth
     * @return BankCardCreateRequest
     */
    public function setCardExpireMonth($cardExpireMonth)
    {
        $this->cardExpireMonth = $cardExpireMonth;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardExpireYear()
    {
        return $this->cardExpireYear;
    }

    /**
     * @param string $cardExpireYear
     * @return BankCardCreateRequest
     */
    public function setCardExpireYear($cardExpireYear)
    {
        $this->cardExpireYear = $cardExpireYear;
        return $this;
    }

    /**
     * @return string
     */
    public function getClientIp()
    {
        return $this->clientIp;
    }

    /**
     * @param string $clientIp
     * @return BankCardCreateRequest
     */
    public function setClientIp($clientIp)
    {
        $this->clientIp = $clientIp;
        return $this;
    }

    #endregion properties

    #region JsonSerializable

    /**
     * Specify data which should be serialized to JSON
     * @link https://php.net/manual/en/jsonserializable.jsonserialize.php
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource.
     * @since 5.4.0
     */
    public function jsonSerialize()
    {
        return array(
            "userId" => $this->userId,
            "cardAlias" => $this->cardAlias,
            "cardOwnerName" => $this->cardOwnerName,
            "cardNumber" => $this->cardNumber,
            "cardExpireMonth" => $this->cardExpireMonth,
            "cardExpireYear" => $this->cardExpireYear,
            "clientIp" => $this->clientIp
        );
    }

    #endregion JsonSerializable

}
