<?php


namespace Ysb\IPara\Entities;


use Ysb\IPara\Helpers\Xml\XmlNode;
use Ysb\IPara\Helpers\Xml\IToXmlNode;

class Purchaser implements IToXmlNode
{

    #region fields
    /** @var string */
    public $name;

    /** @var string */
    public $surname;

    /** @var string */
    public $birthDate;

    /** @var string */
    public $email;

    /** @var string */
    public $gsmPhone;

    /** @var string */
    public $identityNumber;

    /** @var string */
    public $clientIp;

    /** @var PurchaserAddress */
    public $invoiceAddress;

    /** @var PurchaserAddress */
    public $ShippingAddress;


    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Purchaser
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getSurname()
    {
        return $this->surname;
    }

    /**
     * @param string $surname
     * @return Purchaser
     */
    public function setSurname($surname)
    {
        $this->surname = $surname;
        return $this;
    }

    /**
     * @return string
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }

    /**
     * @param string $birthDate
     * @return Purchaser
     */
    public function setBirthDate($birthDate)
    {
        $this->birthDate = $birthDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return Purchaser
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getGsmPhone()
    {
        return $this->gsmPhone;
    }

    /**
     * @param string $gsmPhone
     * @return Purchaser
     */
    public function setGsmPhone($gsmPhone)
    {
        $this->gsmPhone = $gsmPhone;
        return $this;
    }

    /**
     * @return string
     */
    public function getIdentityNumber()
    {
        return $this->identityNumber;
    }

    /**
     * @param string $identityNumber
     * @return Purchaser
     */
    public function setIdentityNumber($identityNumber)
    {
        $this->identityNumber = $identityNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getClientIp()
    {
        return $this->clientIp;
    }

    /**
     * @param string $clientIp
     * @return Purchaser
     */
    public function setClientIp($clientIp)
    {
        $this->clientIp = $clientIp;
        return $this;
    }

    /**
     * @return PurchaserAddress
     */
    public function getInvoiceAddress()
    {
        return $this->invoiceAddress;
    }

    /**
     * @param PurchaserAddress $invoiceAddress
     * @return Purchaser
     */
    public function setInvoiceAddress($invoiceAddress)
    {
        $this->invoiceAddress = $invoiceAddress;
        return $this;
    }

    /**
     * @return PurchaserAddress
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }

    /**
     * @param PurchaserAddress $ShippingAddress
     * @return Purchaser
     */
    public function setShippingAddress($ShippingAddress)
    {
        $this->ShippingAddress = $ShippingAddress;
        return $this;
    }

    #endregion properties

    #region IToXmlNode

    /**
     * @param bool $root
     * @return XmlNode
     */
    public function toXmlNode($root = false)
    {
        $purchaser = (new XmlNode('purchaser'))
            ->setRoot($root)
            ->addChild(new XmlNode('name', urldecode($this->getName())))
            ->addChild(new XmlNode('surname', urldecode($this->getSurname())))
            ->addChild(new XmlNode('birthDate', $this->getBirthDate()))
            ->addChild(new XmlNode('email', $this->getEmail()))
            ->addChild(new XmlNode('gsmNumber', urldecode($this->getGsmPhone())))
            ->addChild(new XmlNode('tcCertificate', urldecode($this->getIdentityNumber())))
            ->addChild(new XmlNode('clientIp', $this->getClientIp()));

        if ($this->getInvoiceAddress()) {
            $invAddr = $this->getInvoiceAddress()->toXmlNode(false);
            $invAddr->setTagName('invoiceAddress');
            $purchaser->addChild($invAddr);
        }
        if ($this->getShippingAddress()) {
            $shpAddr = $this->getShippingAddress()->toXmlNode(false);
            $shpAddr->setTagName('shippingAddress');
            $purchaser->addChild($shpAddr);
        }

        return $purchaser;
    }

    /**
     * @param bool $useIndent
     * @param int $indentLevel
     * @param string $indentChars
     * @return string
     */
    public function toXmlString($useIndent = false, $indentLevel = 0, $indentChars = '    ')
    {
        return $this->toXmlNode()
            ->toXmlString($useIndent,$indentLevel,$indentChars);
    }

    #endregion IToXmlNode

}