<?php


namespace Ysb\IPara\Entities;


use Ysb\IPara\Helpers\Xml\XmlNode;
use Ysb\IPara\Helpers\Xml\IToXmlNode;

class Product implements IToXmlNode
{
    #region fields

    /** @var string */
    protected $code;

    /** @var string */
    protected $title;

    /** @var int */
    protected $quantity;

    /** @var string */
    protected $price;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return Product
     */
    public function setCode($code)
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     * @return Product
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param int $quantity
     * @return Product
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;
        return $this;
    }

    /**
     * @return string
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @param string $price
     * @return Product
     */
    public function setPrice($price)
    {
        $this->price = $price;
        return $this;
    }

    #endregion properties

    #region IToXmlNode

    /**
     * @param bool $root
     * @return XmlNode
     */
    public function toXmlNode($root = false)
    {
        $prd = (new XmlNode('product'))
            ->setRoot($root)
            ->addChild(new XmlNode('productCode',urldecode($this->getCode())))
            ->addChild(new XmlNode('productName',urldecode($this->getTitle())))
            ->addChild(new XmlNode('quantity',$this->getQuantity()))
            ->addChild(new XmlNode('price',$this->getPrice()));
        return $prd;
    }

    /**
     * @param bool $useIndent
     * @param int $indentLevel
     * @param string $indentChars
     * @return string
     */
    public function toXmlString($useIndent = false, $indentLevel = 0, $indentChars = '    ')
    {
        return $this->toXmlNode()
            ->toXmlString($useIndent,$indentLevel,$indentChars);
    }

    #endregion IToXmlNode
}