<?php


namespace Ysb\IPara\Entities;


class PaymentLinkRecord
{
    #region fields

    /** @var string */
    protected $amount;

    /** @var string */
    protected $creationDate;

    /** @var string */
    protected $description;

    /** @var string */
    protected $email;

    /** @var string */
    protected $gsm;

    /** @var string */
    protected $linkId;

    /** @var string */
    protected $linkState;

    /** @var string */
    protected $name;

    /** @var string */
    protected $surname;

    /** @var string */
    protected $taxNumber;

    /** @var string */
    protected $tcCertificate;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param string $amount
     * @return PaymentLinkRecord
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }

    /**
     * @param string $creationDate
     * @return PaymentLinkRecord
     */
    public function setCreationDate($creationDate)
    {
        $this->creationDate = $creationDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     * @return PaymentLinkRecord
     */
    public function setDescription($description)
    {
        $this->description = $description;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return PaymentLinkRecord
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getGsm()
    {
        return $this->gsm;
    }

    /**
     * @param string $gsm
     * @return PaymentLinkRecord
     */
    public function setGsm($gsm)
    {
        $this->gsm = $gsm;
        return $this;
    }

    /**
     * @return string
     */
    public function getLinkId()
    {
        return $this->linkId;
    }

    /**
     * @param string $linkId
     * @return PaymentLinkRecord
     */
    public function setLinkId($linkId)
    {
        $this->linkId = $linkId;
        return $this;
    }

    /**
     * @return string
     */
    public function getLinkState()
    {
        return $this->linkState;
    }

    /**
     * @param string $linkState
     * @return PaymentLinkRecord
     */
    public function setLinkState($linkState)
    {
        $this->linkState = $linkState;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return PaymentLinkRecord
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getSurname()
    {
        return $this->surname;
    }

    /**
     * @param string $surname
     * @return PaymentLinkRecord
     */
    public function setSurname($surname)
    {
        $this->surname = $surname;
        return $this;
    }

    /**
     * @return string
     */
    public function getTaxNumber()
    {
        return $this->taxNumber;
    }

    /**
     * @param string $taxNumber
     * @return PaymentLinkRecord
     */
    public function setTaxNumber($taxNumber)
    {
        $this->taxNumber = $taxNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getTcCertificate()
    {
        return $this->tcCertificate;
    }

    /**
     * @param string $tcCertificate
     * @return PaymentLinkRecord
     */
    public function setTcCertificate($tcCertificate)
    {
        $this->tcCertificate = $tcCertificate;
        return $this;
    }

    #endregion properties

    #region static

    /**
     * @param object|array $object
     * @return PaymentLinkRecord
     */
    public static function fromObject($object){
        if(is_array($object)){
            $object = (object) $object;
        }
        $res = new static();

        if(isset($object->amount)){
            $res->amount = $object->amount;
        }

        if(isset($object->creationDate)){
            $res->creationDate = $object->creationDate;
        }

        if(isset($object->description)){
            $res->description = $object->description;
        }

        if(isset($object->email)){
            $res->email = $object->email;
        }

        if(isset($object->gsm)){
            $res->gsm = $object->gsm;
        }

        if(isset($object->linkId)){
            $res->linkId = $object->linkId;
        }

        if(isset($object->linkState)){
            $res->linkState = $object->linkState;
        }

        if(isset($object->name)){
            $res->name = $object->name;
        }

        if(isset($object->surname)){
            $res->surname = $object->surname;
        }

        if(isset($object->taxNumber)){
            $res->taxNumber = $object->taxNumber;
        }

        if(isset($object->tcCertificate)){
            $res->tcCertificate = $object->tcCertificate;
        }

        return $res;
    }

    #endregion static

}