<?php

include_once "vendor\autoload.php";

$isCli = php_sapi_name() == "cli";
$lineBreak = $isCli ? PHP_EOL : '<br>';

$settings = new \Ysb\IPara\Settings(
    'K0YRHD1L0P0LLOB',
    'K0YRHD1L0P0LLOBJIP08GJUAD',
    true
);
$settings->setTestMode(true);

$client = new \Ysb\IPara\IParaClient($settings);

#region (Non-3d) Ödeme

$request = new \Ysb\IPara\Request\ApiPaymentRequest();

$request->setEcho('Echo')
    ->setOrderId(\Ysb\IPara\Helpers\Helper::GUID())
    ->setAmount(100.00 * 100)
    ->setCardOwnerName('Murat Kaya')
    ->setCardNumber('5571135571135575')
    ->setCardExpireMonth('12')
    ->setCardExpireYear('22')
    ->setInstallment(1)
    ->setCvc('000')
    ->setThreeD('false');

$purchaser = new \Ysb\IPara\Entities\Purchaser();

$purchaser->setName('Murat')
    ->setSurname('Kaya')
    ->setBirthDate('1986-07-11')
    ->setEmail('murat@kaya.com')
    ->setGsmPhone('5881231212')
    ->setIdentityNumber('1234567890')
    ->setClientIp(\Ysb\IPara\Helpers\Helper::get_client_ip());

$invoiceAddress = new \Ysb\IPara\Entities\PurchaserAddress();

$invoiceAddress->setName('Murat')
    ->setSurname('Kaya')
    ->setAddress('Mevlüt Pehlivan Mah-> Multinet Plaza Şişli')
    ->setZipCode('34782')
    ->setCityCode('34')
    ->setIdentityNumber('1234567890')
    ->setCountryCode('TR')
    ->setTaxNumber('123456')
    ->setTaxOffice('Kozyatağı')
    ->setCompanyName('iPara')
    ->setPhoneNumber('2122222222');

$purchaser->setInvoiceAddress($invoiceAddress);

$shippingAddress = new \Ysb\IPara\Entities\PurchaserAddress();
$shippingAddress->setName('Murat')
    ->setSurname('Kaya')
    ->setAddress('Mevlüt Pehlivan Mah-> Multinet Plaza Şişli')
    ->setZipCode('34782')
    ->setCityCode('34')
    ->setIdentityNumber('1234567890')
    ->setCountryCode('TR')
    ->setTaxNumber('123456')
    ->setTaxOffice('Kozyatağı')
    ->setCompanyName('iPara')
    ->setPhoneNumber('2122222222');

$purchaser->setShippingAddress($shippingAddress);

$request->setPurchaser($purchaser);

$p = new \Ysb\IPara\Entities\Product();
$p->setTitle("Telefon")
    ->setCode('TLF0001')
    ->setPrice(50.00 * 100)
    ->setQuantity(1);

$request->addProduct($p);



$p2 = new \Ysb\IPara\Entities\Product();
$p2->setTitle("Bilgisayar")
    ->setCode('BLG0001')
    ->setPrice(50.00 * 100)
    ->setQuantity(1);

$request->addProduct($p2);

//var_dump($request->toXmlString(true));
$response =  $client->payment($request);

if($response->getResult()){
    // Başarılı
    echo 'ResponseMessage : ' . $response->getResponseMessage();
    echo 'Amount : ' . $response->getAmount();

}else{
    // Hata
    echo 'ErrorCode : ' . $response->getErrorCode() . $lineBreak;
    echo 'ErrorMessage : ' . $response->getErrorMessage() . $lineBreak;
}

#endregion (Non-3d) Ödeme

#region 3D Secure ile Ödeme (1. request)

$request = new \Ysb\IPara\Request\ThreeDPaymentInitRequest();

$request->setOrderId(\Ysb\IPara\Helpers\Helper::GUID())
    ->setEcho('echo')
    ->setAmount(100 * 100)
    ->setCardOwnerName('Murat Kaya')
    ->setCardNumber('5571135571135575')
    ->setCardExpireMonth('12')
    ->setCardExpireYear('22')
    ->setInstallment('1')
    ->setCvc('000')
    ->setPurchaserName('Murat')
    ->setPurchaserSurname('Kaya')
    ->setPurchaserEmail('murat@kaya.com')
    ->setSuccessUrl('http://www.example.com/' ."success.php")
    ->setFailUrl('http://www.example.com/' ."fail.php");

$htmlForm = $client->threeDPaymentInit($request);

print $htmlForm;

#endregion 3D Secure ile Ödeme (1. request)