<?php


namespace Ysb\IPara;

/*
Tüm çağrılarda kullanılacak ayarların tutulduğu sınıftır.
Bu sınıf üzerinde size özel parametreler fonksiyonlar arasında taşınabilir.
Bu sınıf üzerinde tüm sistemde kullanacağımız ayarları tutar ve bunlara göre işlem yaparız.
Bu sınıf örnek projemizde BaseController içerisinde kullanılmıştır. Ve tüm ayarların kullanılacağı yerde karşımıza çıkmaktadır.
*/

class Settings
{
    #region fields

    /**
     *Public Magaza Anahtarı - size mağaza başvurunuz sonucunda gönderilen public key
     * (açık anahtar) bilgisini kullanınız.
     *
     * @var string
     */
    protected $publicKey;

    /**
     * Private Magaza Anahtarı  - size mağaza başvurunuz sonucunda gönderilen privaye key
     * (gizli anahtar) bilgisini kullanınız.
     * @var string
     */
    protected $privateKey;

    /**
     * iPara web servisleri API url'lerinin başlangıç bilgisidir.
     *
     * @var string
     */
    protected $baseUrl;

    /**
     * iPara 3D operasyonu için güvenlik sorgusu servisinin URL bilgisi.
     *
     * @var string
     */
    protected $threeDInquiryUrl;

    /**
     * Test -> T, entegrasyon testlerinin sırasında "T" modunu,
     * canlı sisteme entegre olarak ödeme almaya başlamak için ise
     * Prod -> "P" modunu kullanınız.
     *
     * @var string
     */
    protected $mode = 'P';

    /**
     * Kullandığınız iPara API versiyonudur.
     *
     * @var string
     */
    protected $version;

    /**
     * Kullanacağınız hash bilgisini, bağlanmak istediğiniz
     * web servis bilgisine göre doldurulmalıdır.
     *
     * @var string
     */
    protected $hashString;

    /**
     * IPara.DeveloperPortal.Core.Helper#GetTransactionDateString()
     * ile transaction'in gerçekleştiği zaman bilgisini iletmekte kullanılır.
     *
     * @var string
     */
    protected $transactionDate;

    #endregion fields

    #region ctor

    /**
     * Settings constructor.
     * @param string $publicKey
     * @param string $privateKey
     * @param bool $testMode
     */
    public function __construct($publicKey,$privateKey, $testMode =false)
    {
        $this->publicKey = $publicKey;
        $this->privateKey = $privateKey;
        $this->baseUrl = 'https://api.ipara.com/';
        $this->version = '1.0';
        $this->mode = $testMode ? 'T' : 'P';
        $this->hashString = "";
        $this->transactionDate = "";
        $this->threeDInquiryUrl = "https://www.ipara.com/3dgate";

    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getPublicKey()
    {
        return $this->publicKey;
    }

    /**
     * @param string $publicKey
     */
    public function setPublicKey($publicKey)
    {
        $this->publicKey = $publicKey;
    }

    /**
     * @return string
     */
    public function getPrivateKey()
    {
        return $this->privateKey;
    }

    /**
     * @param string $privateKey
     */
    public function setPrivateKey($privateKey)
    {
        $this->privateKey = $privateKey;
    }

    /**
     * @return string
     */
    public function getBaseUrl()
    {
        return $this->baseUrl;
    }

    /**
     * @param string $baseUrl
     */
    public function setBaseUrl($baseUrl)
    {
        $this->baseUrl = $baseUrl;
    }

    /**
     * @return string
     */
    public function getThreeDInquiryUrl()
    {
        return $this->threeDInquiryUrl;
    }

    /**
     * @param string $threeDInquiryUrl
     */
    public function setThreeDInquiryUrl($threeDInquiryUrl)
    {
        $this->threeDInquiryUrl = $threeDInquiryUrl;
    }

    /**
     * @return string
     */
    public function getMode()
    {
        return $this->mode;
    }

    /**
     * @param string $mode
     */
    public function setMode($mode)
    {
        $this->mode = $mode;
    }

    /**
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * @param string $version
     */
    public function setVersion($version)
    {
        $this->version = $version;
    }

    /**
     * @return string
     */
    public function getHashString()
    {
        return $this->hashString;
    }

    /**
     * @param string $hashString
     */
    public function setHashString($hashString)
    {
        $this->hashString = $hashString;
    }

    /**
     * @return string
     */
    public function getTransactionDate()
    {
        return $this->transactionDate;
    }

    /**
     * @param string $transactionDate
     */
    public function setTransactionDate($transactionDate)
    {
        $this->transactionDate = $transactionDate;
    }

    #endregion properties

    #region methods

    public function setTestMode($testMode = true){
        $this->mode = $testMode ? 'T' : 'P';
    }

    #endregion methods

}