<?php


namespace Ysb\IPara\Response;


class LinkPaymentCreateResponse extends BaseResponse
{
    #region fields

    /** @var string */
    protected $amount;

    /** @var string */
    protected $link;

    /** @var string */
    protected $linkPaymentId;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param string $amount
     * @return LinkPaymentCreateResponse
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string
     */
    public function getLink()
    {
        return $this->link;
    }

    /**
     * @param string $link
     * @return LinkPaymentCreateResponse
     */
    public function setLink($link)
    {
        $this->link = $link;
        return $this;
    }

    /**
     * @return string
     */
    public function getLinkPaymentId()
    {
        return $this->linkPaymentId;
    }

    /**
     * @param string $linkPaymentId
     * @return LinkPaymentCreateResponse
     */
    public function setLinkPaymentId($linkPaymentId)
    {
        $this->linkPaymentId = $linkPaymentId;
        return $this;
    }

    #endregion properties

    #region static

    /**
     * @param object|\SimpleXMLElement $object
     * @return LinkPaymentCreateResponse
     */
    public static function fromObject($object){
        $res = new static();

        if(isset($object->amount)){
            $res->amount = $object->amount;
        }

        if(isset($object->link)){
            $res->link = $object->link;
        }

        if(isset($object->linkPaymentId)){
            $res->linkPaymentId = $object->linkPaymentId;
        }

        $res->fillFromObject($object);
        return $res;
    }

    #endregion static

}