<?php


namespace Ysb\IPara\Response;


use Ysb\IPara\Entities\BankCard;

class BankCardInquryResponse extends BaseResponse
{

    #region fields

    /** @var array|BankCard[] */
    protected $cards = array();

    #endregion fields

    #region properties

    /**
     * @return array|BankCard[]
     */
    public function getCards()
    {
        return $this->cards;
    }

    /**
     * @param array|BankCard[] $cards
     * @return BankCardInquryResponse
     */
    public function setCards($cards)
    {
        $this->cards = $cards;
        return $this;
    }

    #endregion properties

    #region methods

    /**
     * @param BankCard $bankCard
     * @return $this
     */
    public function addBankCard($bankCard){
        $this->cards[] = $bankCard;
        return $this;
    }

    #endregion methods

    #region statics

    /**
     * @param object|\SimpleXMLElement $object
     * @return BankCardInquryResponse
     */
    public static function fromObject($object){
        $res = new static();
        $res->fillFromObject($object);
        if(isset($object->cards) && is_array($object->cards)){
            foreach ($object->cards as $card){
                $c = BankCard::fromObject($card);
                $res->addBankCard($c);
            }
        }
        return $res;
    }

    #endregion statics

}