<?php


namespace Ysb\IPara\Response;


class BankCardCreateResponse extends BaseResponse
{

    #region fields

    /** @var string */
    protected $cardId;

    /** @var string */
    protected $maskNumber;

    /** @var string */
    protected $alias;

    /** @var string */
    protected $bankId;

    /** @var string */
    protected $bankName;

    /** @var string */
    protected $cardFamilyName;

    /** @var string */
    protected $supportsInstallment;

    /** @var array|string[] */
    protected $supportedInstallments = array();

    /** @var string */
    protected $type;

    /** @var string */
    protected $serviceProvider;

    /** @var string */
    protected $threeDSecureMandatory;

    /** @var string */
    protected $cvcMandatory ;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getCardId()
    {
        return $this->cardId;
    }

    /**
     * @param string $cardId
     * @return BankCardCreateResponse
     */
    public function setCardId($cardId)
    {
        $this->cardId = $cardId;
        return $this;
    }

    /**
     * @return string
     */
    public function getMaskNumber()
    {
        return $this->maskNumber;
    }

    /**
     * @param string $maskNumber
     * @return BankCardCreateResponse
     */
    public function setMaskNumber($maskNumber)
    {
        $this->maskNumber = $maskNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getAlias()
    {
        return $this->alias;
    }

    /**
     * @param string $alias
     * @return BankCardCreateResponse
     */
    public function setAlias($alias)
    {
        $this->alias = $alias;
        return $this;
    }

    /**
     * @return string
     */
    public function getBankId()
    {
        return $this->bankId;
    }

    /**
     * @param string $bankId
     * @return BankCardCreateResponse
     */
    public function setBankId($bankId)
    {
        $this->bankId = $bankId;
        return $this;
    }

    /**
     * @return string
     */
    public function getBankName()
    {
        return $this->bankName;
    }

    /**
     * @param string $bankName
     * @return BankCardCreateResponse
     */
    public function setBankName($bankName)
    {
        $this->bankName = $bankName;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardFamilyName()
    {
        return $this->cardFamilyName;
    }

    /**
     * @param string $cardFamilyName
     * @return BankCardCreateResponse
     */
    public function setCardFamilyName($cardFamilyName)
    {
        $this->cardFamilyName = $cardFamilyName;
        return $this;
    }

    /**
     * @return string
     */
    public function getSupportsInstallment()
    {
        return $this->supportsInstallment;
    }

    /**
     * @param string $supportsInstallment
     * @return BankCardCreateResponse
     */
    public function setSupportsInstallment($supportsInstallment)
    {
        $this->supportsInstallment = $supportsInstallment;
        return $this;
    }

    /**
     * @return array|string[]
     */
    public function getSupportedInstallments()
    {
        return $this->supportedInstallments;
    }

    /**
     * @param array|string[] $supportedInstallments
     * @return BankCardCreateResponse
     */
    public function setSupportedInstallments($supportedInstallments)
    {
        $this->supportedInstallments = $supportedInstallments;
        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return BankCardCreateResponse
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return string
     */
    public function getServiceProvider()
    {
        return $this->serviceProvider;
    }

    /**
     * @param string $serviceProvider
     * @return BankCardCreateResponse
     */
    public function setServiceProvider($serviceProvider)
    {
        $this->serviceProvider = $serviceProvider;
        return $this;
    }

    /**
     * @return string
     */
    public function getThreeDSecureMandatory()
    {
        return $this->threeDSecureMandatory;
    }

    /**
     * @param string $threeDSecureMandatory
     * @return BankCardCreateResponse
     */
    public function setThreeDSecureMandatory($threeDSecureMandatory)
    {
        $this->threeDSecureMandatory = $threeDSecureMandatory;
        return $this;
    }

    /**
     * @return string
     */
    public function getCvcMandatory()
    {
        return $this->cvcMandatory;
    }

    /**
     * @param string $cvcMandatory
     * @return BankCardCreateResponse
     */
    public function setCvcMandatory($cvcMandatory)
    {
        $this->cvcMandatory = $cvcMandatory;
        return $this;
    }

    #endregion properties

    #region static

    /**
     * @param \SimpleXMLElement|object $element
     * @return $this
     */
    public static function fromObject($element)
    {
        $res = new static();

        if(isset($element->cardId)){
            $res->setCardId($element->cardId);
        }

        if(isset($element->maskNumber)){
            $res->setMaskNumber($element->maskNumber);
        }

        if(isset($element->alias)){
            $res->setAlias($element->alias);
        }

        if(isset($element->bankId)){
            $res->setBankId($element->bankId);
        }

        if(isset($element->bankName)){
            $res->setBankName($element->bankName);
        }

        if(isset($element->cardFamilyName)){
            $res->setCardFamilyName($element->cardFamilyName);
        }

        if(isset($element->supportsInstallment)){
            $res->setSupportsInstallment($element->supportsInstallment);
        }
        if(isset($element->supportedInstallments) && is_array($element->supportedInstallments)){
            $res->setSupportedInstallments($element->supportedInstallments);
        }

        if(isset($element->type)){
            $res->setType($element->type);
        }

        if(isset($element->serviceProvider)){
            $res->setServiceProvider($element->serviceProvider);
        }

        if(isset($element->threeDSecureMandatory)){
            $res->setThreeDSecureMandatory($element->threeDSecureMandatory);
        }

        if(isset($element->cvcMandatory)){
            $res->setCvcMandatory($element->cvcMandatory);
        }

        $res->fillFromObject($element);
        return $res;

    }

    #endregion static

}
