<?php


namespace Ysb\IPara\Request;


use Ysb\IPara\Helpers\Html\IToHtmlString;

class ThreeDPaymentInitRequest extends BaseRequest implements IToHtmlString
{

    #region fields
    /** @var string */
    protected $orderId;

    /** @var string */
    protected $amount;

    /** @var string */
    protected $userId;

    /** @var string */
    protected $cardId;

    /** @var string */
    protected $cardOwnerName;

    /** @var string */
    protected $cardNumber;

    /** @var string */
    protected $cardExpireMonth;

    /** @var string */
    protected $cardExpireYear;

    /** @var string */
    protected $installment;

    /** @var string */
    protected $cvc;

    /** @var string */
    protected $purchaserName;

    /** @var string */
    protected $purchaserSurname;

    /** @var string */
    protected $purchaserEmail;

    /** @var string */
    protected $successUrl;

    /** @var string */
    protected $failUrl;

    /** @var string */
    protected $version;

    /** @var string */
    protected $transactionDate;

    /** @var string */
    protected $token;

    #endregion fields

    #region Properties

    /**
     * @return string
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param string $orderId
     * @return ThreeDPaymentInitRequest
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
        return $this;
    }

    /**
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param string $amount
     * @return ThreeDPaymentInitRequest
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param string $userId
     * @return ThreeDPaymentInitRequest
     */
    public function setUserId($userId)
    {
        $this->userId = $userId;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardId()
    {
        return $this->cardId;
    }

    /**
     * @param string $cardId
     * @return ThreeDPaymentInitRequest
     */
    public function setCardId($cardId)
    {
        $this->cardId = $cardId;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardOwnerName()
    {
        return $this->cardOwnerName;
    }

    /**
     * @param string $cardOwnerName
     * @return ThreeDPaymentInitRequest
     */
    public function setCardOwnerName($cardOwnerName)
    {
        $this->cardOwnerName = $cardOwnerName;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardNumber()
    {
        return $this->cardNumber;
    }

    /**
     * @param string $cardNumber
     * @return ThreeDPaymentInitRequest
     */
    public function setCardNumber($cardNumber)
    {
        $this->cardNumber = $cardNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardExpireMonth()
    {
        return $this->cardExpireMonth;
    }

    /**
     * @param string $cardExpireMonth
     * @return ThreeDPaymentInitRequest
     */
    public function setCardExpireMonth($cardExpireMonth)
    {
        $this->cardExpireMonth = $cardExpireMonth;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardExpireYear()
    {
        return $this->cardExpireYear;
    }

    /**
     * @param string $cardExpireYear
     * @return ThreeDPaymentInitRequest
     */
    public function setCardExpireYear($cardExpireYear)
    {
        $this->cardExpireYear = $cardExpireYear;
        return $this;
    }

    /**
     * @return string
     */
    public function getInstallment()
    {
        return $this->installment;
    }

    /**
     * @param string $installment
     * @return ThreeDPaymentInitRequest
     */
    public function setInstallment($installment)
    {
        $this->installment = $installment;
        return $this;
    }

    /**
     * @return string
     */
    public function getCvc()
    {
        return $this->cvc;
    }

    /**
     * @param string $cvc
     * @return ThreeDPaymentInitRequest
     */
    public function setCvc($cvc)
    {
        $this->cvc = $cvc;
        return $this;
    }

    /**
     * @return string
     */
    public function getPurchaserName()
    {
        return $this->purchaserName;
    }

    /**
     * @param string $purchaserName
     * @return ThreeDPaymentInitRequest
     */
    public function setPurchaserName($purchaserName)
    {
        $this->purchaserName = $purchaserName;
        return $this;
    }

    /**
     * @return string
     */
    public function getPurchaserSurname()
    {
        return $this->purchaserSurname;
    }

    /**
     * @param string $purchaserSurname
     * @return ThreeDPaymentInitRequest
     */
    public function setPurchaserSurname($purchaserSurname)
    {
        $this->purchaserSurname = $purchaserSurname;
        return $this;
    }

    /**
     * @return string
     */
    public function getPurchaserEmail()
    {
        return $this->purchaserEmail;
    }

    /**
     * @param string $purchaserEmail
     * @return ThreeDPaymentInitRequest
     */
    public function setPurchaserEmail($purchaserEmail)
    {
        $this->purchaserEmail = $purchaserEmail;
        return $this;
    }

    /**
     * @return string
     */
    public function getSuccessUrl()
    {
        return $this->successUrl;
    }

    /**
     * @param string $successUrl
     * @return ThreeDPaymentInitRequest
     */
    public function setSuccessUrl($successUrl)
    {
        $this->successUrl = $successUrl;
        return $this;
    }

    /**
     * @return string
     */
    public function getFailUrl()
    {
        return $this->failUrl;
    }

    /**
     * @param string $failUrl
     * @return ThreeDPaymentInitRequest
     */
    public function setFailUrl($failUrl)
    {
        $this->failUrl = $failUrl;
        return $this;
    }

    /**
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * @param string $version
     * @return ThreeDPaymentInitRequest
     */
    public function setVersion($version)
    {
        $this->version = $version;
        return $this;
    }

    /**
     * @return string
     */
    public function getTransactionDate()
    {
        return $this->transactionDate;
    }

    /**
     * @param string $transactionDate
     * @return ThreeDPaymentInitRequest
     */
    public function setTransactionDate($transactionDate)
    {
        $this->transactionDate = $transactionDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * @param string $token
     * @return ThreeDPaymentInitRequest
     */
    public function setToken($token)
    {
        $this->token = $token;
        return $this;
    }

    #endregion Properties


    #region IToHtmlString

    public function toHtmlString($settings)
    {
        $builder = "";

        $builder .= "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">";
        $builder .= "<html>";
        $builder .= "<body>";
        $builder .= "<form action=\"" . $settings->getThreeDInquiryUrl() . "\" method=\"post\" id=\"three_d_form\" >";
        $builder .= "<input type=\"hidden\" name=\"orderId\" value=\"" . $this->orderId . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"amount\" value=\"" . $this->amount . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"cardOwnerName\" value=\"" . $this->cardOwnerName . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"cardNumber\" value=\"" . $this->cardNumber . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"userId\" value=\"" . $this->userId . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"cardId\" value=\"" . $this->cardId . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"cardExpireMonth\" value=\"" . $this->cardExpireMonth . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"cardExpireYear\" value=\"" . $this->cardExpireYear . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"installment\" value=\"" . $this->installment . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"cardCvc\" value=\"" . $this->cvc . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"mode\" value=\"" . $this->mode . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"purchaserName\" value=\"" . $this->purchaserName . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"purchaserSurname\" value=\"" . $this->purchaserSurname . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"purchaserEmail\" value=\"" . $this->purchaserEmail . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"successUrl\" value=\"" . $this->successUrl . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"failureUrl\" value=\"" . $this->failUrl . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"echo\" value=\"" . $this->echo . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"version\" value=\"" . $this->version . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"transactionDate\" value=\"" . $this->transactionDate . "\"/>";
        $builder .= "<input type=\"hidden\" name=\"token\" value=\"" . $this->token . "\"/>";
        $builder .= "<input type=\"submit\" value=\"Öde\" style=\"display:none;\"/>";
        $builder .= "<noscript>";
        $builder .= "<br/>";
        $builder .= "<br/>";
        $builder .= "<center>";
        $builder .= "<h1>3D Secure Yönlendirme İşlemi</h1>";
        $builder .= "<h2>Javascript internet tarayıcınızda kapatılmış veya desteklenmiyor.<br/></h2>";
        $builder .= "<h3>Lütfen banka 3D Secure sayfasına yönlenmek için tıklayınız.</h3>";
        $builder .= "<input type=\"submit\" value=\"3D Secure Sayfasına Yönlen\">";
        $builder .= "</center>";
        $builder .= "</noscript>";
        $builder .= "</form>";
        $builder .= "</body>";
        $builder .= "<script>document.getElementById(\"three_d_form\").submit();</script>";
        $builder .= "</html>";
        return $builder;
    }

    #endregion IToHtmlString

}