<?php


namespace Ysb\IPara\Request;


use JsonSerializable;

class LinkPaymentCreateRequest extends BaseRequest implements JsonSerializable
{
    #region fields

    /** @var string */
    protected $name;

    /** @var string */
    protected $surname;

    /** @var string */
    protected $tcCertificate;

    /** @var string */
    protected $taxNumber;

    /** @var string */
    protected $email;

    /** @var string */
    protected $gsm;

    /** @var string */
    protected $amount;

    /** @var string */
    protected $threeD;

    /** @var string */
    protected $expireDate;

    /** @var array */
    protected $installmentList = array();

    /** @var string */
    protected $sendEmail;

    /** @var string */
    protected $commissionType;

    /** @var string */
    protected $clientIp;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return LinkPaymentCreateRequest
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getSurname()
    {
        return $this->surname;
    }

    /**
     * @param string $surname
     * @return LinkPaymentCreateRequest
     */
    public function setSurname($surname)
    {
        $this->surname = $surname;
        return $this;
    }

    /**
     * @return string
     */
    public function getTcCertificate()
    {
        return $this->tcCertificate;
    }

    /**
     * @param string $tcCertificate
     * @return LinkPaymentCreateRequest
     */
    public function setTcCertificate($tcCertificate)
    {
        $this->tcCertificate = $tcCertificate;
        return $this;
    }

    /**
     * @return string
     */
    public function getTaxNumber()
    {
        return $this->taxNumber;
    }

    /**
     * @param string $taxNumber
     * @return LinkPaymentCreateRequest
     */
    public function setTaxNumber($taxNumber)
    {
        $this->taxNumber = $taxNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return LinkPaymentCreateRequest
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getGsm()
    {
        return $this->gsm;
    }

    /**
     * @param string $gsm
     * @return LinkPaymentCreateRequest
     */
    public function setGsm($gsm)
    {
        $this->gsm = $gsm;
        return $this;
    }

    /**
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param string $amount
     * @return LinkPaymentCreateRequest
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string
     */
    public function getThreeD()
    {
        return $this->threeD;
    }

    /**
     * @param string $threeD
     * @return LinkPaymentCreateRequest
     */
    public function setThreeD($threeD)
    {
        $this->threeD = $threeD;
        return $this;
    }

    /**
     * @return string
     */
    public function getExpireDate()
    {
        return $this->expireDate;
    }

    /**
     * @param string $expireDate
     * @return LinkPaymentCreateRequest
     */
    public function setExpireDate($expireDate)
    {
        $this->expireDate = $expireDate;
        return $this;
    }

    /**
     * @return array
     */
    public function getInstallmentList()
    {
        return $this->installmentList;
    }

    /**
     * @param array $installmentList
     * @return LinkPaymentCreateRequest
     */
    public function setInstallmentList($installmentList)
    {
        $this->installmentList = $installmentList;
        return $this;
    }

    /**
     * @return string
     */
    public function getSendEmail()
    {
        return $this->sendEmail;
    }

    /**
     * @param string $sendEmail
     * @return LinkPaymentCreateRequest
     */
    public function setSendEmail($sendEmail)
    {
        $this->sendEmail = $sendEmail;
        return $this;
    }

    /**
     * @return string
     */
    public function getCommissionType()
    {
        return $this->commissionType;
    }

    /**
     * @param string $commissionType
     * @return LinkPaymentCreateRequest
     */
    public function setCommissionType($commissionType)
    {
        $this->commissionType = $commissionType;
        return $this;
    }

    /**
     * @return string
     */
    public function getClientIp()
    {
        return $this->clientIp;
    }

    /**
     * @param string $clientIp
     * @return LinkPaymentCreateRequest
     */
    public function setClientIp($clientIp)
    {
        $this->clientIp = $clientIp;
        return $this;
    }

    #endregion properties



    #region JsonSerializable

    /**
     * Specify data which should be serialized to JSON
     * @link https://php.net/manual/en/jsonserializable.jsonserialize.php
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource.
     * @since 5.4.0
     */
    public function jsonSerialize()
    {
        return array(
            "name" => $this->name,
            "surname" => $this->surname,
            "tcCertificate" => $this->tcCertificate,
            "taxNumber" => $this->taxNumber,
            "email" => $this->email,
            "gsm" => $this->gsm,
            "amount" => $this->amount,
            "threeD" => $this->threeD,
            "expireDate" => $this->expireDate,
            "installmentList" => $this->installmentList,
            "sendEmail" => $this->sendEmail,
            "commissionType" => $this->commissionType,
            "clientIp" => $this->clientIp
        );
    }

    #endregion JsonSerializable
}