<?php


namespace Ysb\IPara\Request;


use JsonSerializable;

class BankCardDeleteRequest extends BaseRequest implements JsonSerializable
{
    #region fields

    /** @var string */
    protected $userId;

    /** @var string */
    protected $cardId;

    /** @var string */
    protected $clientIp;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param string $userId
     * @return BankCardDeleteRequest
     */
    public function setUserId($userId)
    {
        $this->userId = $userId;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardId()
    {
        return $this->cardId;
    }

    /**
     * @param string $cardId
     * @return BankCardDeleteRequest
     */
    public function setCardId($cardId)
    {
        $this->cardId = $cardId;
        return $this;
    }

    /**
     * @return string
     */
    public function getClientIp()
    {
        return $this->clientIp;
    }

    /**
     * @param string $clientIp
     * @return BankCardDeleteRequest
     */
    public function setClientIp($clientIp)
    {
        $this->clientIp = $clientIp;
        return $this;
    }


    #endregion properties


    #region JsonSerializable

    /**
     * Specify data which should be serialized to JSON
     * @link https://php.net/manual/en/jsonserializable.jsonserialize.php
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource.
     * @since 5.4.0
     */
    public function jsonSerialize()
    {
        return array(
            "userId" => $this->userId,
            "cardId" => $this->cardId,
            "clientIp" => $this->clientIp
        );
    }

    #endregion JsonSerializable

}