<?php


namespace Ysb\IPara\Request;


use Ysb\IPara\Entities\Product;
use Ysb\IPara\Entities\Purchaser;
use Ysb\IPara\Helpers\Xml\XmlNode;
use Ysb\IPara\Helpers\Xml\IToXmlNode;

class ApiPaymentRequest extends BaseRequest implements IToXmlNode
{

    #region fields

    /** @var string */
    protected $threeD;

    /** @var string */
    protected $orderId;

    /** @var string */
    protected $amount;

    /** @var string */
    protected $cardOwnerName;

    /**
     * @var string
     */
    protected $cardNumber;

    /** @var string */
    protected $cardExpireMonth;

    /** @var string */
    protected $cardExpireYear;

    /** @var string */
    protected $installment;

    /** @var string */
    protected $cvc;

    /** @var string */
    protected $vendorId;

    /** @var string */
    protected $userId;

    /** @var string */
    protected $cardId;

    /** @var string */
    protected $threeDSecureCode;

    /** @var array|Product[] */
    protected $products = array();

    /** @var Purchaser */
    protected $purchaser;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getThreeD()
    {
        return $this->threeD;
    }

    /**
     * @param string $threeD
     * @return ApiPaymentRequest
     */
    public function setThreeD($threeD)
    {
        $this->threeD = $threeD;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param string $orderId
     * @return ApiPaymentRequest
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
        return $this;
    }

    /**
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param string $amount
     * @return ApiPaymentRequest
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardOwnerName()
    {
        return $this->cardOwnerName;
    }

    /**
     * @param string $cardOwnerName
     * @return ApiPaymentRequest
     */
    public function setCardOwnerName($cardOwnerName)
    {
        $this->cardOwnerName = $cardOwnerName;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardNumber()
    {
        return $this->cardNumber;
    }

    /**
     * @param string $cardNumber
     * @return ApiPaymentRequest
     */
    public function setCardNumber($cardNumber)
    {
        $this->cardNumber = $cardNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardExpireMonth()
    {
        return $this->cardExpireMonth;
    }

    /**
     * @param string $cardExpireMonth
     * @return ApiPaymentRequest
     */
    public function setCardExpireMonth($cardExpireMonth)
    {
        $this->cardExpireMonth = $cardExpireMonth;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardExpireYear()
    {
        return $this->cardExpireYear;
    }

    /**
     * @param string $cardExpireYear
     * @return ApiPaymentRequest
     */
    public function setCardExpireYear($cardExpireYear)
    {
        $this->cardExpireYear = $cardExpireYear;
        return $this;
    }

    /**
     * @return string
     */
    public function getInstallment()
    {
        return $this->installment;
    }

    /**
     * @param string $installment
     * @return ApiPaymentRequest
     */
    public function setInstallment($installment)
    {
        $this->installment = $installment;
        return $this;
    }

    /**
     * @return string
     */
    public function getCvc()
    {
        return $this->cvc;
    }

    /**
     * @param string $cvc
     * @return ApiPaymentRequest
     */
    public function setCvc($cvc)
    {
        $this->cvc = $cvc;
        return $this;
    }

    /**
     * @return string
     */
    public function getVendorId()
    {
        return $this->vendorId;
    }

    /**
     * @param string $vendorId
     * @return ApiPaymentRequest
     */
    public function setVendorId($vendorId)
    {
        $this->vendorId = $vendorId;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param string $userId
     * @return ApiPaymentRequest
     */
    public function setUserId($userId)
    {
        $this->userId = $userId;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardId()
    {
        return $this->cardId;
    }

    /**
     * @param string $cardId
     * @return ApiPaymentRequest
     */
    public function setCardId($cardId)
    {
        $this->cardId = $cardId;
        return $this;
    }

    /**
     * @return string
     */
    public function getThreeDSecureCode()
    {
        return $this->threeDSecureCode;
    }

    /**
     * @param string $threeDSecureCode
     * @return ApiPaymentRequest
     */
    public function setThreeDSecureCode($threeDSecureCode)
    {
        $this->threeDSecureCode = $threeDSecureCode;
        return $this;
    }

    /**
     * @return array|Product[]
     */
    public function getProducts()
    {
        return $this->products;
    }

    /**
     * @param array|Product[] $products
     * @return ApiPaymentRequest
     */
    public function setProducts($products)
    {
        $this->products = $products;
        return $this;
    }

    /**
     * @return Purchaser
     */
    public function getPurchaser()
    {
        return $this->purchaser;
    }

    /**
     * @param Purchaser $purchaser
     * @return ApiPaymentRequest
     */
    public function setPurchaser($purchaser)
    {
        $this->purchaser = $purchaser;
        return $this;
    }

    #endregion properties

    #region methods

    /**
     * @param Product $product
     * @return $this
     */
    public function addProduct($product){
        $this->products[] = $product;
        return $this;
    }

    #endregion methods

    #region IToXmlNode

    /**
     * @param bool $root
     * @return XmlNode
     */
    public function toXmlNode($root = false)
    {
        $auth = new XmlNode('auth');

        $auth->setRoot($root)
            ->addChild(new XmlNode('threeD', $this->getThreeD()))
            ->addChild(new XmlNode('orderId', $this->getOrderId()))
            ->addChild(new XmlNode('amount', $this->getAmount()))
            ->addChild(new XmlNode('cardOwnerName', urldecode($this->getCardOwnerName())))
            ->addChild(new XmlNode('cardNumber', $this->getCardNumber()))
            ->addChild(new XmlNode('cardExpireMonth', $this->getCardExpireMonth()))
            ->addChild(new XmlNode('cardExpireYear', $this->getCardExpireYear()))
            ->addChild(new XmlNode('installment', $this->getInstallment()))
            ->addChild(new XmlNode('cardCvc', $this->getCvc()))
            ->addChild(new XmlNode('userId', $this->getUserId()))
            ->addChild(new XmlNode('cardId', $this->getCardId()))
            ->addChild(new XmlNode('mode', $this->getMode()));
        if($this->getThreeD() == 'true'){
            $auth->addChild(new XmlNode('threeDSecureCode', $this->getThreeDSecureCode()));
        }
        if ($this->getVendorId()) {
            $auth->addChild(new XmlNode('vendorId', $this->getVendorId()));
        }
        $products = new XmlNode('products');

        foreach ($this->products as $prd){
            $products->addChild($prd->toXmlNode(false));
        }
        $auth->addChild($products);

        if($this->getPurchaser()){
            $auth->addChild($this->getPurchaser()->toXmlNode(false));
        }

        return $auth;
    }

    /**
     * @param bool $useIndent
     * @param int $indentLevel
     * @param string $indentChars
     * @return string
     */
    public function toXmlString($useIndent = false, $indentLevel = 0, $indentChars = '    ')
    {
        return $this->toXmlNode(true)
            ->toXmlString($useIndent,$indentLevel,$indentChars);
    }

    #endregion IToXmlNode


}
