<?php


namespace Ysb\IPara\Entities;


use Ysb\IPara\Helpers\Xml\XmlNode;
use Ysb\IPara\Helpers\Xml\IToXmlNode;

class PurchaserAddress implements IToXmlNode
{

    #region fields

    /** @var string */
    public $name;

    /** @var string */
    public $surname;

    /** @var string */
    public $address;

    /** @var string */
    public $zipCode;

    /** @var string */
    public $cityCode;

    /** @var string */
    public $identityNumber;

    /** @var string */
    public $countryCode;

    /** @var string */
    public $taxNumber;

    /** @var string */
    public $taxOffice;

    /** @var string */
    public $companyName;

    /** @var string */
    public $phoneNumber;

    #endregion fields

    #region Properties

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return PurchaserAddress
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getSurname()
    {
        return $this->surname;
    }

    /**
     * @param string $surname
     * @return PurchaserAddress
     */
    public function setSurname($surname)
    {
        $this->surname = $surname;
        return $this;
    }

    /**
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * @param string $address
     * @return PurchaserAddress
     */
    public function setAddress($address)
    {
        $this->address = $address;
        return $this;
    }

    /**
     * @return string
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }

    /**
     * @param string $zipCode
     * @return PurchaserAddress
     */
    public function setZipCode($zipCode)
    {
        $this->zipCode = $zipCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getCityCode()
    {
        return $this->cityCode;
    }

    /**
     * @param string $cityCode
     * @return PurchaserAddress
     */
    public function setCityCode($cityCode)
    {
        $this->cityCode = $cityCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getIdentityNumber()
    {
        return $this->identityNumber;
    }

    /**
     * @param string $identityNumber
     * @return PurchaserAddress
     */
    public function setIdentityNumber($identityNumber)
    {
        $this->identityNumber = $identityNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }

    /**
     * @param string $countryCode
     * @return PurchaserAddress
     */
    public function setCountryCode($countryCode)
    {
        $this->countryCode = $countryCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getTaxNumber()
    {
        return $this->taxNumber;
    }

    /**
     * @param string $taxNumber
     * @return PurchaserAddress
     */
    public function setTaxNumber($taxNumber)
    {
        $this->taxNumber = $taxNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getTaxOffice()
    {
        return $this->taxOffice;
    }

    /**
     * @param string $taxOffice
     * @return PurchaserAddress
     */
    public function setTaxOffice($taxOffice)
    {
        $this->taxOffice = $taxOffice;
        return $this;
    }

    /**
     * @return string
     */
    public function getCompanyName()
    {
        return $this->companyName;
    }

    /**
     * @param string $companyName
     * @return PurchaserAddress
     */
    public function setCompanyName($companyName)
    {
        $this->companyName = $companyName;
        return $this;
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }

    /**
     * @param string $phoneNumber
     * @return PurchaserAddress
     */
    public function setPhoneNumber($phoneNumber)
    {
        $this->phoneNumber = $phoneNumber;
        return $this;
    }

    #endregion Properties

    #region IToXmlNode

    /**
     * @param bool $root
     * @return XmlNode
     */
    public function toXmlNode($root = false)
    {
        $adr = (new XmlNode('purchaserAddress'))
            ->setRoot($root)
            ->addChild(new XmlNode('name', urldecode($this->getName())))
            ->addChild(new XmlNode('surname', urldecode($this->getSurname())))
            ->addChild(new XmlNode('address', urldecode($this->getAddress())))
            ->addChild(new XmlNode('zipcode', urldecode($this->getZipCode())))
            ->addChild(new XmlNode('city', urldecode($this->getCityCode())))
            ->addChild(new XmlNode('tcCertificate', urldecode($this->getIdentityNumber())))
            ->addChild(new XmlNode('country', urldecode($this->getCountryCode())))
            ->addChild(new XmlNode('taxNumber', urldecode($this->getTaxNumber())))
            ->addChild(new XmlNode('taxOffice', urldecode($this->getTaxOffice())))
            ->addChild(new XmlNode('companyName', urldecode($this->getCompanyName())))
            ->addChild(new XmlNode('phoneNumber', urldecode($this->getPhoneNumber())));
        return $adr;

    }

    /**
     * @param bool $useIndent
     * @param int $indentLevel
     * @param string $indentChars
     * @return string
     */
    public function toXmlString($useIndent = false, $indentLevel = 0, $indentChars = '    ')
    {
        return $this->toXmlNode()
            ->toXmlString($useIndent,$indentLevel,$indentChars);
    }

    #endregion IToXmlNode
}