<?php


namespace Ysb\IPara\Entities;


class BankCard
{

    #region fields

    /**
     * @var string
     */
    public $cardId;

    /**
     * @var string
     */
    public $maskNumber;

    /**
     * @var string
     */
    public $alias;

    /**
     * @var string
     */
    public $bankId;

    /**
     * @var string
     */
    public $bankName;

    /**
     * @var string
     */
    public $cardFamilyName;

    /**
     * @var string
     */
    public $supportsInstallment;
    /**
     * @var array|string[]
     */
    public $supportedInstallments;
    /**
     * @var string
     */
    public $type;

    /**
     * @var string
     */
    public $serviceProvider;

    /**
     * @var string
     */
    public $threeDSecureMandatory;

    /**
     * @var string
     */
    public $cvcMandatory;

    #endregion fields

    #region properties

    /**
     * @return string
     */
    public function getCardId()
    {
        return $this->cardId;
    }

    /**
     * @param string $cardId
     * @return $this
     */
    public function setCardId($cardId)
    {
        $this->cardId = $cardId;
        return $this;
    }

    /**
     * @return string
     */
    public function getMaskNumber()
    {
        return $this->maskNumber;
    }

    /**
     * @param string $maskNumber
     * @return $this
     */
    public function setMaskNumber($maskNumber)
    {
        $this->maskNumber = $maskNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getAlias()
    {
        return $this->alias;
    }

    /**
     * @param string $alias
     * @return $this
     */
    public function setAlias($alias)
    {
        $this->alias = $alias;
        return $this;
    }

    /**
     * @return string
     */
    public function getBankId()
    {
        return $this->bankId;
    }

    /**
     * @param string $bankId
     * @return $this
     */
    public function setBankId($bankId)
    {
        $this->bankId = $bankId;
        return $this;
    }

    /**
     * @return string
     */
    public function getBankName()
    {
        return $this->bankName;
    }

    /**
     * @param string $bankName
     * @return $this
     */
    public function setBankName($bankName)
    {
        $this->bankName = $bankName;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardFamilyName()
    {
        return $this->cardFamilyName;
    }

    /**
     * @param string $cardFamilyName
     * @return $this
     */
    public function setCardFamilyName($cardFamilyName)
    {
        $this->cardFamilyName = $cardFamilyName;
        return $this;
    }

    /**
     * @return string
     */
    public function getSupportsInstallment()
    {
        return $this->supportsInstallment;
    }

    /**
     * @param string $supportsInstallment
     * @return $this
     */
    public function setSupportsInstallment($supportsInstallment)
    {
        $this->supportsInstallment = $supportsInstallment;
        return $this;
    }

    /**
     * @return array|string[]
     */
    public function getSupportedInstallments()
    {
        return $this->supportedInstallments;
    }

    /**
     * @param array|string[] $supportedInstallments
     * @return $this
     */
    public function setSupportedInstallments($supportedInstallments)
    {
        $this->supportedInstallments = $supportedInstallments;
        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return string
     */
    public function getServiceProvider()
    {
        return $this->serviceProvider;
    }

    /**
     * @param string $serviceProvider
     * @return $this
     */
    public function setServiceProvider($serviceProvider)
    {
        $this->serviceProvider = $serviceProvider;
        return $this;
    }

    /**
     * @return string
     */
    public function getThreeDSecureMandatory()
    {
        return $this->threeDSecureMandatory;
    }

    /**
     * @param string $threeDSecureMandatory
     * @return $this
     */
    public function setThreeDSecureMandatory($threeDSecureMandatory)
    {
        $this->threeDSecureMandatory = $threeDSecureMandatory;
        return $this;
    }

    /**
     * @return string
     */
    public function getCvcMandatory()
    {
        return $this->cvcMandatory;
    }

    /**
     * @param string $cvcMandatory
     * @return $this
     */
    public function setCvcMandatory($cvcMandatory)
    {
        $this->cvcMandatory = $cvcMandatory;
        return $this;
    }

    #endregion properties

    #region statics

    public static function fromObject($object){
        $res = new static();

        if(isset($object->cardId)){
            $res->cardId = $object->cardId;
        }
        if(isset($object->maskNumber)){
            $res->maskNumber = $object->maskNumber;
        }
        if(isset($object->alias)){
            $res->alias = $object->alias;
        }
        if(isset($object->cardFamilyName)){
            $res->cardFamilyName = $object->cardFamilyName;
        }
        if(isset($object->bankId )){
            $res->bankId  = $object->bankId;
        }
        if(isset($object->bankName)){
            $res->bankName = $object->bankName;
        }
        if(isset($object->supportsInstallment)){
            $res->supportsInstallment = $object->supportsInstallment;
        }
        if(isset($object->supportedInstallments) && is_array($object->supportedInstallments)){
            $res->supportedInstallments = $object->supportedInstallments;
        }
        if(isset($object->type)){
            $res->type = $object->type;
        }
        if(isset($object->serviceProvider)){
            $res->serviceProvider = $object->serviceProvider;
        }
        if(isset($object->threeDSecureMandatory)){
            $res->threeDSecureMandatory = $object->threeDSecureMandatory;
        }
        if(isset($object->cvcMandatory)){
            $res->cvcMandatory = $object->cvcMandatory;
        }
        return $res;
    }

    #endregion statics

}