<?php


namespace Ysb\Inbox\Entities;


class ResponseObject
{

    #region properties

    /** @var string */
    public string $version;

    /** @var bool */
    public bool $resultStatus;

    /** @var int  */
    public int $resultCode;

    /** @var string|null  */
    public ?string $resultMessage;

    /** @var mixed */
    public $resultObject;

    #endregion properties

    #region statics

    /**
     * @param object $obj
     * @return static
     */
    public static function fromObject(object $obj):self{
        $res = new self();
        $reflect = new \ReflectionClass(self::class);
        $props = $reflect->getProperties(\ReflectionProperty::IS_PUBLIC);
        foreach ($props as $prp){
           $nm=  $prp->getName();
            if(isset($obj->$nm)){
                $res->$nm = $obj->$nm;
            }
        }

        return $res;
    }

    public static function fromJsonString(string $jsonStr):self {
        return static::fromObject(json_decode($jsonStr));
    }

    #endregion statics

}