<?php


namespace Ysb\Inbox\Entities;


use JsonSerializable;

class EmailInfo implements JsonSerializable
{
    #region ctor

    public function __construct(string $email = "", ?string $name = null)
    {
        $this->email = $email;
        $this->name = $name;
    }

    #endregion ctor

    #region properties

    public string $email;

    public ?string $name = null;

    #endregion properties

    #region JsonSerializable

    public function jsonSerialize()
    {
        $res = [];
        if(!empty($this->name)){
            $res['name'] = $this->name;
        }
        $res['email'] = $this->email;
        return (object)$res;
    }

    #endregion JsonSerializable
}