<?php


namespace Ysb\Inbox\Entities;


use JsonSerializable;

class SendEmail implements JsonSerializable
{
    #region fields

    protected EmailInfo $from;

    /** @var array|EmailInfo[]  */
    protected array $to = array();

    /** @var string  */
    protected string $subject;

    /** @var string  */
    protected string $htmlContent;

    /** @var array|Attachment[]  */
    protected array $attachments = array();



    #endregion fields

    #region properties

    /**
     * @return EmailInfo
     */
    public function getFrom(): EmailInfo
    {
        return $this->from;
    }

    /**
     * @param EmailInfo $from
     * @return SendEmail
     */
    public function setFrom(EmailInfo $from): SendEmail
    {
        $this->from = $from;
        return $this;
    }

    /**
     * @return array|EmailInfo[]
     */
    public function getTo()
    {
        return $this->to;
    }

    /**
     * @param array|EmailInfo[] $to
     * @return SendEmail
     */
    public function setTo($to)
    {
        $this->to = $to;
        return $this;
    }

    /**
     * @return string
     */
    public function getSubject(): string
    {
        return $this->subject;
    }

    /**
     * @param string $subject
     * @return SendEmail
     */
    public function setSubject(string $subject): SendEmail
    {
        $this->subject = $subject;
        return $this;
    }

    /**
     * @return string
     */
    public function getHtmlContent(): string
    {
        return $this->htmlContent;
    }

    /**
     * @param string $htmlContent
     * @return SendEmail
     */
    public function setHtmlContent(string $htmlContent): SendEmail
    {
        $this->htmlContent = $htmlContent;
        return $this;
    }

    /**
     * @return array|Attachment[]
     */
    public function getAttachments()
    {
        return $this->attachments;
    }

    /**
     * @param array|Attachment[] $attachments
     * @return SendEmail
     */
    public function setAttachments($attachments)
    {
        $this->attachments = $attachments;
        return $this;
    }
    #endregion properties

    #region methods

    /**
     * @param string $name
     * @param string $email
     * @return $this
     */
    public function setFromNameAndEmail(string $name,string $email):self {
        $this->setFrom(new EmailInfo($email,$name));
        return $this;
    }

    /**
     * @param EmailInfo $emailInfo
     * @return $this
     */
    public function addToEmailInfo(EmailInfo $emailInfo):self {
        $this->to[] = $emailInfo;
        return $this;
    }

    /**
     * @param string $email
     * @param string|null $name
     * @return $this
     */
    public function addTo(string $email, ?string $name = null ):self {
        $inf = new EmailInfo($email,$name);
        $this->addToEmailInfo($inf);
        return $this;
    }

    /**
     * @param Attachment $attachment
     * @return $this
     */
    public function addAttachmentObj(Attachment $attachment):self {
        $this->attachments[] = $attachment;
        return $this;
    }

    /**
     * @param string $name
     * @param string $url
     * @return $this
     */
    public function addAttachment(string $name, string $url):self {
        $atch = new Attachment($name,$url);
        $this->addAttachmentObj($atch);
        return $this;
    }

    #endregion methods

    #region JsonSerializable

    public function jsonSerialize()
    {
        $res = [
            'from' => $this->from,
            'to' => $this->to,
            'subject' => $this->subject,
            'htmlContent' => $this->htmlContent,
        ];
        if(!empty($this->attachments)){
            $res['attachments'] = $this->attachments;
        }
        return (object)$res;
    }

    #endregion JsonSerializable

}