<?php


namespace Ys\EuromsgRest;


class MailData implements \JsonSerializable
{
    #region fields

    /** @var string */
    public string $fromName;

    /** @var string */
    public string $fromAddress;

    /** @var string|null */
    public ?string $replyAddress = null;

    /** @var string */
    public string $subject = "";

    /** @var string */
    public string $htmlBody;

    /** @var string */
    public string $charset = "UTF-8";

    /** @var string */
    public string $toName;

    /** @var string */
    public string $toEmailAddress;

    /** @var string|null */
    public ?string $postType = null;

    /** @var string|null */
    public ?string $keyId = null;

    /**
     * @var string|null
     */
    public ?string $customParams = null;

    /**
     * @var array|MailAttachment[]
     */
    public array $attachments = array();

    /** @var string|null  */
    public ?string $ccAddress = null;

    /** @var string|null  */
    public ?string $bccAddress = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getFromName(): string
    {
        return $this->fromName;
    }

    /**
     * @param string $fromName
     * @return MailData
     */
    public function setFromName(string $fromName): MailData
    {
        $this->fromName = $fromName;
        return $this;
    }

    /**
     * @return string
     */
    public function getFromAddress(): string
    {
        return $this->fromAddress;
    }

    /**
     * @param string $fromAddress
     * @return MailData
     */
    public function setFromAddress(string $fromAddress): MailData
    {
        $this->fromAddress = $fromAddress;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getReplyAddress(): ?string
    {
        return $this->replyAddress;
    }

    /**
     * @param string|null $replyAddress
     * @return MailData
     */
    public function setReplyAddress(?string $replyAddress): MailData
    {
        $this->replyAddress = $replyAddress;
        return $this;
    }

    /**
     * @return string
     */
    public function getSubject(): string
    {
        return $this->subject;
    }

    /**
     * @param string $subject
     * @return MailData
     */
    public function setSubject(string $subject): MailData
    {
        $this->subject = $subject;
        return $this;
    }

    /**
     * @return string
     */
    public function getHtmlBody(): string
    {
        return $this->htmlBody;
    }

    /**
     * @param string $htmlBody
     * @return MailData
     */
    public function setHtmlBody(string $htmlBody): MailData
    {
        $this->htmlBody = $htmlBody;
        return $this;
    }

    /**
     * @return string
     */
    public function getCharset(): string
    {
        return $this->charset;
    }

    /**
     * @param string $charset
     * @return MailData
     */
    public function setCharset(string $charset): MailData
    {
        $this->charset = $charset;
        return $this;
    }

    /**
     * @return string
     */
    public function getToName(): string
    {
        return $this->toName;
    }

    /**
     * @param string $toName
     * @return MailData
     */
    public function setToName(string $toName): MailData
    {
        $this->toName = $toName;
        return $this;
    }

    /**
     * @return string
     */
    public function getToEmailAddress(): string
    {
        return $this->toEmailAddress;
    }

    /**
     * @param string $toEmailAddress
     * @return MailData
     */
    public function setToEmailAddress(string $toEmailAddress): MailData
    {
        $this->toEmailAddress = $toEmailAddress;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPostType(): ?string
    {
        return $this->postType;
    }

    /**
     * @param string|null $postType
     * @return MailData
     */
    public function setPostType(?string $postType): MailData
    {
        $this->postType = $postType;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getKeyId(): ?string
    {
        return $this->keyId;
    }

    /**
     * @param string|null $keyId
     * @return MailData
     */
    public function setKeyId(?string $keyId): MailData
    {
        $this->keyId = $keyId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCustomParams(): ?string
    {
        return $this->customParams;
    }

    /**
     * @param string|null $customParams
     * @return MailData
     */
    public function setCustomParams(?string $customParams): MailData
    {
        $this->customParams = $customParams;
        return $this;
    }

    /**
     * @return array|MailAttachment[]
     */
    public function getAttachments()
    {
        return $this->attachments;
    }

    /**
     * @param array|MailAttachment[] $attachments
     * @return MailData
     */
    public function setAttachments($attachments)
    {
        $this->attachments = $attachments;
        return $this;
    }

    #endregion properties

    #region methods

    /**
     * @param MailAttachment $mailAttachment
     * @return $this
     */
    public function addAttachment(MailAttachment $mailAttachment): self
    {
        $this->attachments[] = $mailAttachment;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCcAddress(): ?string
    {
        return $this->ccAddress;
    }

    /**
     * @param string|null $ccAddress
     * @return MailData
     */
    public function setCcAddress(?string $ccAddress): MailData
    {
        $this->ccAddress = $ccAddress;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBccAddress(): ?string
    {
        return $this->bccAddress;
    }

    /**
     * @param string|null $bccAddress
     * @return MailData
     */
    public function setBccAddress(?string $bccAddress): MailData
    {
        $this->bccAddress = $bccAddress;
        return $this;
    }

    #endregion methods

    #region JsonSerializable

    public function jsonSerialize()
    {
        $res = [
            'FromName' => $this->fromName,
            'FromAddress' => $this->fromAddress,
            'ReplyAddress' => isset($this->replyAddress) ? $this->replyAddress : "",
            'Subject' => $this->subject,
            'HtmlBody' => $this->htmlBody,
            'Charset' => $this->charset,
            'ToName' => $this->toName,
            'ToEmailAddress' => $this->toEmailAddress,
        ];

        if (isset($this->postType) && !empty($this->postType)) {
            $res['PostType'] = $this->postType;
        }

        if (isset($this->keyId) && !empty($this->keyId)) {
            $res['KeyId'] = $this->keyId;
        }

        if (isset($this->customParams) && !empty($this->customParams)) {
            $res['CustomParams'] = $this->customParams;
        }
        $res['Attachments'] = $this->attachments;

        if(!empty($this->ccAddress) || !empty($this->bccAddress) ){
            if (isset($this->ccAddress) && !empty($this->ccAddress)) {
                $res['CcAddress'] = $this->ccAddress;
            }else{
                $res['CcAddress'] = "";
            }
            if (isset($this->bccAddress) && !empty($this->bccAddress)) {
                $res['BccAddress'] = $this->bccAddress;
            }else{
                $res['BccAddress'] = "";
            }
        }


        return (object)$res;
    }

    #endregion JsonSerializable

}