<?php


namespace Ys\EuromsgRest;


class MailAttachment implements \JsonSerializable
{

    #region fields

    /** @var string  */
    public string $name;

    /** @var string  */
    public string $type;

    /** @var string  */
    public string $content;

    #endregion fields

    #region ctor

    /**
     * MailAttachment constructor.
     * @param string|null $name
     * @param string|null $type
     * @param string|null $base64Content
     */
    public function __construct(?string $name = null, ?string $type = null, ?string $base64Content = null)
    {
        if($name !== null){
            $this->name = $name;
        }
        if($type !== null){
            $this->type = $type;
        }
        if($base64Content !== null){
            $this->content = $base64Content;
        }
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return MailAttachment
     */
    public function setName(string $name): MailAttachment
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return MailAttachment
     */
    public function setType(string $type): MailAttachment
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return string
     */
    public function getBase64Content(): string
    {
        return $this->content;
    }

    /**
     * @param string $content
     * @return MailAttachment
     */
    public function setBase64Content(string $content): MailAttachment
    {
        $this->content = $content;
        return $this;
    }

    /**
     * @return string
     */
    public function getContent(): string
    {
        if(!empty($this->content)){
            return base64_decode($this->content);
        }
        return "";
    }

    /**
     * @param string $content
     * @return MailAttachment
     */
    public function setContent(string $content): MailAttachment
    {
        $this->content = base64_encode($content);
        return $this;
    }

    #endregion properties

    #region JsonSerializable

    public function jsonSerialize()
    {
        return (object)[
            'Name' => $this->name,
            'Type' => $this->type,
            'Content' => $this->content
        ];
    }

    #endregion JsonSerializable
}