<?php


namespace Ys\EuromsgRest;


class EuromsgRestClient
{

    #region fields

    /**
     * @var string
     */
    protected string $baseApiUrl = 'http://api.relateddigital.com/resta/api/';

    /**
     * @var string|null
     */
    protected ?string $ticket = null;

    /**
     * @var string
     */
    protected string $username = "username";

    /**
     * @var string
     */
    protected string $password = "password";

    /**
     * @var string|null
     */
    protected ?string $lastErorr = null;


    #endregion fields

    #region ctor

    /**
     * EuromsgRestCliient constructor.
     * @param array $options
     */
    public function __construct(array $options = array())
    {
        if (isset($options['baseApiUrl'])) {
            $this->baseApiUrl = $options['baseApiUrl'];
        }

        if (isset($options['ticket'])) {
            $this->ticket = $options['ticket'];
        }

        if (isset($options['username'])) {
            $this->username = $options['username'];
        }
        if (isset($options['password'])) {
            $this->password = $options['password'];
        }

    }

    #endregion ctor

    #region methods

    /**
     * @return bool
     */
    public function login()
    {
        try {
            $url = $this->baseApiUrl . "auth/login";
            $reqObj = (object)[
                'UserName' => $this->username,
                'Password' => $this->password
            ];

            $postdata = json_encode($reqObj);

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
            $result = curl_exec($ch);
            curl_close($ch);
            $res = json_decode($result);
            if ($res->Success) {
                $this->ticket = $res->ServiceTicket;
                return true;
            } else {
                $strErr = "";
                foreach ($res->Errors as $err) {
                    $strErr .=  $err->Code ." - " . $err->Message . " | ";
                }
                if(isset($res->DetailedMessage)){
                    $strErr .= 'DetailedMessage : ' . $res->DetailedMessage;
                }
                $this->lastErorr = $strErr;
                return false;
            }
        }catch (\Throwable $exp){
            $this->lastErorr = $exp->getMessage();
            return false;
        }
    }

    /**
     * @return bool
     */
    public function logout()
    {
        try {
            if(empty($this->ticket)) {
                return true;
            }
            $url = $this->baseApiUrl . "auth/logout";

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Authorization: '.$this->ticket
            ));
            $result = curl_exec($ch);
            curl_close($ch);
            $res = json_decode($result);
            if ($res->Success) {
                $this->ticket = null;
                return true;
            } else {
                $strErr = "";
                foreach ($res->Errors as $err) {
                    $strErr .=  $err->Code ." - " . $err->Message . " | ";
                }
                if(isset($res->DetailedMessage)){
                    $strErr .= 'DetailedMessage : ' . $res->DetailedMessage;
                }
                $this->lastErorr = $strErr;
                return false;
            }
        }catch (\Throwable $exp){
            $this->lastErorr = $exp->getMessage();
            return false;
        }
    }

    public function sendMail(MailData $mailData, int $try = 0 ) {
        try {
            if(empty($this->ticket)) {
                if(!$this->login()){
                    return false;
                }
            }
            $url = $this->baseApiUrl;
            if(!empty($mailData->getBccAddress()) || !empty($mailData->getCcAddress())){
                $url .= "post/PostHtml";
            }

            $postdata = json_encode($mailData);

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Authorization: '.$this->ticket,
                'Content-Type: application/json'
            ));
            $result = curl_exec($ch);
            curl_close($ch);
            $res = json_decode($result);
            if ($res->Success) {
                return true;
            } else {
                $strErr = "";
                foreach ($res->Errors as $err) {
                    if($try == 0){
                        if($err->Code == '01' || $err->Code == '9997' || $err->Code == '99'){
                            return $this->sendMail($mailData,1);
                        }
                    }
                    $strErr .=  $err->Code ." - " . $err->Message . " | ";
                }
                if(isset($res->DetailedMessage)){
                    $strErr .= 'DetailedMessage : ' . $res->DetailedMessage;
                }
                $this->lastErorr = $strErr;
                return false;
            }
        }catch (\Throwable $exp){
            $this->lastErorr = $exp->getMessage();
            return false;
        }
    }


    #endregion methods

}