<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCARGODATA8 StructType
 * @subpackage Structs
 */
class WEBCARGODATA8 extends AbstractStructBase
{
    /**
     * The GONDERICI_ILI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 64
     * @var string
     */
    public $GONDERICI_ILI;
    /**
     * The GONDERICI_ILKODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $GONDERICI_ILKODU;
    /**
     * The ALICI_ILI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 64
     * @var string
     */
    public $ALICI_ILI;
    /**
     * The ALICI_ILKODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $ALICI_ILKODU;
    /**
     * The MESAFE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MESAFE;
    /**
     * The SAAT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SAAT;
    /**
     * Constructor method for WEBCARGODATA8
     * @uses WEBCARGODATA8::setGONDERICI_ILI()
     * @uses WEBCARGODATA8::setGONDERICI_ILKODU()
     * @uses WEBCARGODATA8::setALICI_ILI()
     * @uses WEBCARGODATA8::setALICI_ILKODU()
     * @uses WEBCARGODATA8::setMESAFE()
     * @uses WEBCARGODATA8::setSAAT()
     * @param string $gONDERICI_ILI
     * @param string $gONDERICI_ILKODU
     * @param string $aLICI_ILI
     * @param string $aLICI_ILKODU
     * @param float $mESAFE
     * @param float $sAAT
     */
    public function __construct($gONDERICI_ILI = null, $gONDERICI_ILKODU = null, $aLICI_ILI = null, $aLICI_ILKODU = null, $mESAFE = null, $sAAT = null)
    {
        $this
            ->setGONDERICI_ILI($gONDERICI_ILI)
            ->setGONDERICI_ILKODU($gONDERICI_ILKODU)
            ->setALICI_ILI($aLICI_ILI)
            ->setALICI_ILKODU($aLICI_ILKODU)
            ->setMESAFE($mESAFE)
            ->setSAAT($sAAT);
    }
    /**
     * Get GONDERICI_ILI value
     * @return string|null
     */
    public function getGONDERICI_ILI()
    {
        return $this->GONDERICI_ILI;
    }
    /**
     * Set GONDERICI_ILI value
     * @param string $gONDERICI_ILI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA8
     */
    public function setGONDERICI_ILI($gONDERICI_ILI = null)
    {
        // validation for constraint: string
        if (!is_null($gONDERICI_ILI) && !is_string($gONDERICI_ILI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gONDERICI_ILI, true), gettype($gONDERICI_ILI)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($gONDERICI_ILI) && mb_strlen($gONDERICI_ILI) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($gONDERICI_ILI)), __LINE__);
        }
        $this->GONDERICI_ILI = $gONDERICI_ILI;
        return $this;
    }
    /**
     * Get GONDERICI_ILKODU value
     * @return string|null
     */
    public function getGONDERICI_ILKODU()
    {
        return $this->GONDERICI_ILKODU;
    }
    /**
     * Set GONDERICI_ILKODU value
     * @param string $gONDERICI_ILKODU
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA8
     */
    public function setGONDERICI_ILKODU($gONDERICI_ILKODU = null)
    {
        // validation for constraint: string
        if (!is_null($gONDERICI_ILKODU) && !is_string($gONDERICI_ILKODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gONDERICI_ILKODU, true), gettype($gONDERICI_ILKODU)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($gONDERICI_ILKODU) && mb_strlen($gONDERICI_ILKODU) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($gONDERICI_ILKODU)), __LINE__);
        }
        $this->GONDERICI_ILKODU = $gONDERICI_ILKODU;
        return $this;
    }
    /**
     * Get ALICI_ILI value
     * @return string|null
     */
    public function getALICI_ILI()
    {
        return $this->ALICI_ILI;
    }
    /**
     * Set ALICI_ILI value
     * @param string $aLICI_ILI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA8
     */
    public function setALICI_ILI($aLICI_ILI = null)
    {
        // validation for constraint: string
        if (!is_null($aLICI_ILI) && !is_string($aLICI_ILI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLICI_ILI, true), gettype($aLICI_ILI)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($aLICI_ILI) && mb_strlen($aLICI_ILI) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($aLICI_ILI)), __LINE__);
        }
        $this->ALICI_ILI = $aLICI_ILI;
        return $this;
    }
    /**
     * Get ALICI_ILKODU value
     * @return string|null
     */
    public function getALICI_ILKODU()
    {
        return $this->ALICI_ILKODU;
    }
    /**
     * Set ALICI_ILKODU value
     * @param string $aLICI_ILKODU
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA8
     */
    public function setALICI_ILKODU($aLICI_ILKODU = null)
    {
        // validation for constraint: string
        if (!is_null($aLICI_ILKODU) && !is_string($aLICI_ILKODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLICI_ILKODU, true), gettype($aLICI_ILKODU)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($aLICI_ILKODU) && mb_strlen($aLICI_ILKODU) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($aLICI_ILKODU)), __LINE__);
        }
        $this->ALICI_ILKODU = $aLICI_ILKODU;
        return $this;
    }
    /**
     * Get MESAFE value
     * @return float|null
     */
    public function getMESAFE()
    {
        return $this->MESAFE;
    }
    /**
     * Set MESAFE value
     * @param float $mESAFE
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA8
     */
    public function setMESAFE($mESAFE = null)
    {
        // validation for constraint: float
        if (!is_null($mESAFE) && !(is_float($mESAFE) || is_numeric($mESAFE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mESAFE, true), gettype($mESAFE)), __LINE__);
        }
        $this->MESAFE = $mESAFE;
        return $this;
    }
    /**
     * Get SAAT value
     * @return float|null
     */
    public function getSAAT()
    {
        return $this->SAAT;
    }
    /**
     * Set SAAT value
     * @param float $sAAT
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA8
     */
    public function setSAAT($sAAT = null)
    {
        // validation for constraint: float
        if (!is_null($sAAT) && !(is_float($sAAT) || is_numeric($sAAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sAAT, true), gettype($sAAT)), __LINE__);
        }
        $this->SAAT = $sAAT;
        return $this;
    }
}
