<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCARGODATA4 StructType
 * @subpackage Structs
 */
class WEBCARGODATA4 extends AbstractStructBase
{
    /**
     * The BOLGE_ADI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $BOLGE_ADI;
    /**
     * The ADDRESS
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 256
     * - minOccurs: 0
     * @var string
     */
    public $ADDRESS;
    /**
     * The ILCE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 64
     * @var string
     */
    public $ILCE;
    /**
     * The TELEFON
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $TELEFON;
    /**
     * The EMAIL
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $EMAIL;
    /**
     * Constructor method for WEBCARGODATA4
     * @uses WEBCARGODATA4::setBOLGE_ADI()
     * @uses WEBCARGODATA4::setADDRESS()
     * @uses WEBCARGODATA4::setILCE()
     * @uses WEBCARGODATA4::setTELEFON()
     * @uses WEBCARGODATA4::setEMAIL()
     * @param string $bOLGE_ADI
     * @param string $aDDRESS
     * @param string $iLCE
     * @param string $tELEFON
     * @param string $eMAIL
     */
    public function __construct($bOLGE_ADI = null, $aDDRESS = null, $iLCE = null, $tELEFON = null, $eMAIL = null)
    {
        $this
            ->setBOLGE_ADI($bOLGE_ADI)
            ->setADDRESS($aDDRESS)
            ->setILCE($iLCE)
            ->setTELEFON($tELEFON)
            ->setEMAIL($eMAIL);
    }
    /**
     * Get BOLGE_ADI value
     * @return string|null
     */
    public function getBOLGE_ADI()
    {
        return $this->BOLGE_ADI;
    }
    /**
     * Set BOLGE_ADI value
     * @param string $bOLGE_ADI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA4
     */
    public function setBOLGE_ADI($bOLGE_ADI = null)
    {
        // validation for constraint: string
        if (!is_null($bOLGE_ADI) && !is_string($bOLGE_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bOLGE_ADI, true), gettype($bOLGE_ADI)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($bOLGE_ADI) && mb_strlen($bOLGE_ADI) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($bOLGE_ADI)), __LINE__);
        }
        $this->BOLGE_ADI = $bOLGE_ADI;
        return $this;
    }
    /**
     * Get ADDRESS value
     * @return string|null
     */
    public function getADDRESS()
    {
        return $this->ADDRESS;
    }
    /**
     * Set ADDRESS value
     * @param string $aDDRESS
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA4
     */
    public function setADDRESS($aDDRESS = null)
    {
        // validation for constraint: string
        if (!is_null($aDDRESS) && !is_string($aDDRESS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aDDRESS, true), gettype($aDDRESS)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($aDDRESS) && mb_strlen($aDDRESS) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($aDDRESS)), __LINE__);
        }
        $this->ADDRESS = $aDDRESS;
        return $this;
    }
    /**
     * Get ILCE value
     * @return string|null
     */
    public function getILCE()
    {
        return $this->ILCE;
    }
    /**
     * Set ILCE value
     * @param string $iLCE
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA4
     */
    public function setILCE($iLCE = null)
    {
        // validation for constraint: string
        if (!is_null($iLCE) && !is_string($iLCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iLCE, true), gettype($iLCE)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($iLCE) && mb_strlen($iLCE) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($iLCE)), __LINE__);
        }
        $this->ILCE = $iLCE;
        return $this;
    }
    /**
     * Get TELEFON value
     * @return string|null
     */
    public function getTELEFON()
    {
        return $this->TELEFON;
    }
    /**
     * Set TELEFON value
     * @param string $tELEFON
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA4
     */
    public function setTELEFON($tELEFON = null)
    {
        // validation for constraint: string
        if (!is_null($tELEFON) && !is_string($tELEFON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tELEFON, true), gettype($tELEFON)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($tELEFON) && mb_strlen($tELEFON) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($tELEFON)), __LINE__);
        }
        $this->TELEFON = $tELEFON;
        return $this;
    }
    /**
     * Get EMAIL value
     * @return string|null
     */
    public function getEMAIL()
    {
        return $this->EMAIL;
    }
    /**
     * Set EMAIL value
     * @param string $eMAIL
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA4
     */
    public function setEMAIL($eMAIL = null)
    {
        // validation for constraint: string
        if (!is_null($eMAIL) && !is_string($eMAIL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMAIL, true), gettype($eMAIL)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($eMAIL) && mb_strlen($eMAIL) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($eMAIL)), __LINE__);
        }
        $this->EMAIL = $eMAIL;
        return $this;
    }
}
