<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCARGODATA3 StructType
 * @subpackage Structs
 */
class WEBCARGODATA3 extends AbstractStructBase
{
    /**
     * The MUSTERI_KODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $MUSTERI_KODU;
    /**
     * The SERI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $SERI;
    /**
     * The IRSNO
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $IRSNO;
    /**
     * The REFNO
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $REFNO;
    /**
     * The IRSNO1
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $IRSNO1;
    /**
     * The MOK
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $MOK;
    /**
     * The OT
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $OT;
    /**
     * The TARIH
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 19
     * - minOccurs: 0
     * @var string
     */
    public $TARIH;
    /**
     * The CIKIS_SUBESI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $CIKIS_SUBESI;
    /**
     * The VARIS_SUBESI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $VARIS_SUBESI;
    /**
     * The ALICI_ADI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $ALICI_ADI;
    /**
     * The SEHIR
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 64
     * @var string
     */
    public $SEHIR;
    /**
     * The TUTAR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TUTAR;
    /**
     * The ADET
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ADET;
    /**
     * The DESI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DESI;
    /**
     * The TESLIM_ALAN
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $TESLIM_ALAN;
    /**
     * The TESLIM_TARIHI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $TESLIM_TARIHI;
    /**
     * The TESLIM_SAATI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $TESLIM_SAATI;
    /**
     * The IADE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 5
     * - minOccurs: 0
     * @var string
     */
    public $IADE;
    /**
     * Constructor method for WEBCARGODATA3
     * @uses WEBCARGODATA3::setMUSTERI_KODU()
     * @uses WEBCARGODATA3::setSERI()
     * @uses WEBCARGODATA3::setIRSNO()
     * @uses WEBCARGODATA3::setREFNO()
     * @uses WEBCARGODATA3::setIRSNO1()
     * @uses WEBCARGODATA3::setMOK()
     * @uses WEBCARGODATA3::setOT()
     * @uses WEBCARGODATA3::setTARIH()
     * @uses WEBCARGODATA3::setCIKIS_SUBESI()
     * @uses WEBCARGODATA3::setVARIS_SUBESI()
     * @uses WEBCARGODATA3::setALICI_ADI()
     * @uses WEBCARGODATA3::setSEHIR()
     * @uses WEBCARGODATA3::setTUTAR()
     * @uses WEBCARGODATA3::setADET()
     * @uses WEBCARGODATA3::setDESI()
     * @uses WEBCARGODATA3::setTESLIM_ALAN()
     * @uses WEBCARGODATA3::setTESLIM_TARIHI()
     * @uses WEBCARGODATA3::setTESLIM_SAATI()
     * @uses WEBCARGODATA3::setIADE()
     * @param string $mUSTERI_KODU
     * @param string $sERI
     * @param string $iRSNO
     * @param string $rEFNO
     * @param string $iRSNO1
     * @param string $mOK
     * @param string $oT
     * @param string $tARIH
     * @param string $cIKIS_SUBESI
     * @param string $vARIS_SUBESI
     * @param string $aLICI_ADI
     * @param string $sEHIR
     * @param float $tUTAR
     * @param float $aDET
     * @param float $dESI
     * @param string $tESLIM_ALAN
     * @param string $tESLIM_TARIHI
     * @param string $tESLIM_SAATI
     * @param string $iADE
     */
    public function __construct($mUSTERI_KODU = null, $sERI = null, $iRSNO = null, $rEFNO = null, $iRSNO1 = null, $mOK = null, $oT = null, $tARIH = null, $cIKIS_SUBESI = null, $vARIS_SUBESI = null, $aLICI_ADI = null, $sEHIR = null, $tUTAR = null, $aDET = null, $dESI = null, $tESLIM_ALAN = null, $tESLIM_TARIHI = null, $tESLIM_SAATI = null, $iADE = null)
    {
        $this
            ->setMUSTERI_KODU($mUSTERI_KODU)
            ->setSERI($sERI)
            ->setIRSNO($iRSNO)
            ->setREFNO($rEFNO)
            ->setIRSNO1($iRSNO1)
            ->setMOK($mOK)
            ->setOT($oT)
            ->setTARIH($tARIH)
            ->setCIKIS_SUBESI($cIKIS_SUBESI)
            ->setVARIS_SUBESI($vARIS_SUBESI)
            ->setALICI_ADI($aLICI_ADI)
            ->setSEHIR($sEHIR)
            ->setTUTAR($tUTAR)
            ->setADET($aDET)
            ->setDESI($dESI)
            ->setTESLIM_ALAN($tESLIM_ALAN)
            ->setTESLIM_TARIHI($tESLIM_TARIHI)
            ->setTESLIM_SAATI($tESLIM_SAATI)
            ->setIADE($iADE);
    }
    /**
     * Get MUSTERI_KODU value
     * @return string|null
     */
    public function getMUSTERI_KODU()
    {
        return $this->MUSTERI_KODU;
    }
    /**
     * Set MUSTERI_KODU value
     * @param string $mUSTERI_KODU
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setMUSTERI_KODU($mUSTERI_KODU = null)
    {
        // validation for constraint: string
        if (!is_null($mUSTERI_KODU) && !is_string($mUSTERI_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mUSTERI_KODU, true), gettype($mUSTERI_KODU)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($mUSTERI_KODU) && mb_strlen($mUSTERI_KODU) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($mUSTERI_KODU)), __LINE__);
        }
        $this->MUSTERI_KODU = $mUSTERI_KODU;
        return $this;
    }
    /**
     * Get SERI value
     * @return string|null
     */
    public function getSERI()
    {
        return $this->SERI;
    }
    /**
     * Set SERI value
     * @param string $sERI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setSERI($sERI = null)
    {
        // validation for constraint: string
        if (!is_null($sERI) && !is_string($sERI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sERI, true), gettype($sERI)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($sERI) && mb_strlen($sERI) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($sERI)), __LINE__);
        }
        $this->SERI = $sERI;
        return $this;
    }
    /**
     * Get IRSNO value
     * @return string|null
     */
    public function getIRSNO()
    {
        return $this->IRSNO;
    }
    /**
     * Set IRSNO value
     * @param string $iRSNO
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setIRSNO($iRSNO = null)
    {
        // validation for constraint: string
        if (!is_null($iRSNO) && !is_string($iRSNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iRSNO, true), gettype($iRSNO)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($iRSNO) && mb_strlen($iRSNO) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($iRSNO)), __LINE__);
        }
        $this->IRSNO = $iRSNO;
        return $this;
    }
    /**
     * Get REFNO value
     * @return string|null
     */
    public function getREFNO()
    {
        return $this->REFNO;
    }
    /**
     * Set REFNO value
     * @param string $rEFNO
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setREFNO($rEFNO = null)
    {
        // validation for constraint: string
        if (!is_null($rEFNO) && !is_string($rEFNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEFNO, true), gettype($rEFNO)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($rEFNO) && mb_strlen($rEFNO) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($rEFNO)), __LINE__);
        }
        $this->REFNO = $rEFNO;
        return $this;
    }
    /**
     * Get IRSNO1 value
     * @return string|null
     */
    public function getIRSNO1()
    {
        return $this->IRSNO1;
    }
    /**
     * Set IRSNO1 value
     * @param string $iRSNO1
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setIRSNO1($iRSNO1 = null)
    {
        // validation for constraint: string
        if (!is_null($iRSNO1) && !is_string($iRSNO1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iRSNO1, true), gettype($iRSNO1)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($iRSNO1) && mb_strlen($iRSNO1) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($iRSNO1)), __LINE__);
        }
        $this->IRSNO1 = $iRSNO1;
        return $this;
    }
    /**
     * Get MOK value
     * @return string|null
     */
    public function getMOK()
    {
        return $this->MOK;
    }
    /**
     * Set MOK value
     * @param string $mOK
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setMOK($mOK = null)
    {
        // validation for constraint: string
        if (!is_null($mOK) && !is_string($mOK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mOK, true), gettype($mOK)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($mOK) && mb_strlen($mOK) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($mOK)), __LINE__);
        }
        $this->MOK = $mOK;
        return $this;
    }
    /**
     * Get OT value
     * @return string|null
     */
    public function getOT()
    {
        return $this->OT;
    }
    /**
     * Set OT value
     * @param string $oT
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setOT($oT = null)
    {
        // validation for constraint: string
        if (!is_null($oT) && !is_string($oT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oT, true), gettype($oT)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($oT) && mb_strlen($oT) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($oT)), __LINE__);
        }
        $this->OT = $oT;
        return $this;
    }
    /**
     * Get TARIH value
     * @return string|null
     */
    public function getTARIH()
    {
        return $this->TARIH;
    }
    /**
     * Set TARIH value
     * @param string $tARIH
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setTARIH($tARIH = null)
    {
        // validation for constraint: string
        if (!is_null($tARIH) && !is_string($tARIH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tARIH, true), gettype($tARIH)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($tARIH) && mb_strlen($tARIH) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($tARIH)), __LINE__);
        }
        $this->TARIH = $tARIH;
        return $this;
    }
    /**
     * Get CIKIS_SUBESI value
     * @return string|null
     */
    public function getCIKIS_SUBESI()
    {
        return $this->CIKIS_SUBESI;
    }
    /**
     * Set CIKIS_SUBESI value
     * @param string $cIKIS_SUBESI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setCIKIS_SUBESI($cIKIS_SUBESI = null)
    {
        // validation for constraint: string
        if (!is_null($cIKIS_SUBESI) && !is_string($cIKIS_SUBESI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cIKIS_SUBESI, true), gettype($cIKIS_SUBESI)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($cIKIS_SUBESI) && mb_strlen($cIKIS_SUBESI) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($cIKIS_SUBESI)), __LINE__);
        }
        $this->CIKIS_SUBESI = $cIKIS_SUBESI;
        return $this;
    }
    /**
     * Get VARIS_SUBESI value
     * @return string|null
     */
    public function getVARIS_SUBESI()
    {
        return $this->VARIS_SUBESI;
    }
    /**
     * Set VARIS_SUBESI value
     * @param string $vARIS_SUBESI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setVARIS_SUBESI($vARIS_SUBESI = null)
    {
        // validation for constraint: string
        if (!is_null($vARIS_SUBESI) && !is_string($vARIS_SUBESI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vARIS_SUBESI, true), gettype($vARIS_SUBESI)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($vARIS_SUBESI) && mb_strlen($vARIS_SUBESI) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($vARIS_SUBESI)), __LINE__);
        }
        $this->VARIS_SUBESI = $vARIS_SUBESI;
        return $this;
    }
    /**
     * Get ALICI_ADI value
     * @return string|null
     */
    public function getALICI_ADI()
    {
        return $this->ALICI_ADI;
    }
    /**
     * Set ALICI_ADI value
     * @param string $aLICI_ADI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setALICI_ADI($aLICI_ADI = null)
    {
        // validation for constraint: string
        if (!is_null($aLICI_ADI) && !is_string($aLICI_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLICI_ADI, true), gettype($aLICI_ADI)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($aLICI_ADI) && mb_strlen($aLICI_ADI) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($aLICI_ADI)), __LINE__);
        }
        $this->ALICI_ADI = $aLICI_ADI;
        return $this;
    }
    /**
     * Get SEHIR value
     * @return string|null
     */
    public function getSEHIR()
    {
        return $this->SEHIR;
    }
    /**
     * Set SEHIR value
     * @param string $sEHIR
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setSEHIR($sEHIR = null)
    {
        // validation for constraint: string
        if (!is_null($sEHIR) && !is_string($sEHIR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEHIR, true), gettype($sEHIR)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($sEHIR) && mb_strlen($sEHIR) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($sEHIR)), __LINE__);
        }
        $this->SEHIR = $sEHIR;
        return $this;
    }
    /**
     * Get TUTAR value
     * @return float|null
     */
    public function getTUTAR()
    {
        return $this->TUTAR;
    }
    /**
     * Set TUTAR value
     * @param float $tUTAR
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setTUTAR($tUTAR = null)
    {
        // validation for constraint: float
        if (!is_null($tUTAR) && !(is_float($tUTAR) || is_numeric($tUTAR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tUTAR, true), gettype($tUTAR)), __LINE__);
        }
        $this->TUTAR = $tUTAR;
        return $this;
    }
    /**
     * Get ADET value
     * @return float|null
     */
    public function getADET()
    {
        return $this->ADET;
    }
    /**
     * Set ADET value
     * @param float $aDET
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setADET($aDET = null)
    {
        // validation for constraint: float
        if (!is_null($aDET) && !(is_float($aDET) || is_numeric($aDET))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aDET, true), gettype($aDET)), __LINE__);
        }
        $this->ADET = $aDET;
        return $this;
    }
    /**
     * Get DESI value
     * @return float|null
     */
    public function getDESI()
    {
        return $this->DESI;
    }
    /**
     * Set DESI value
     * @param float $dESI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setDESI($dESI = null)
    {
        // validation for constraint: float
        if (!is_null($dESI) && !(is_float($dESI) || is_numeric($dESI))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dESI, true), gettype($dESI)), __LINE__);
        }
        $this->DESI = $dESI;
        return $this;
    }
    /**
     * Get TESLIM_ALAN value
     * @return string|null
     */
    public function getTESLIM_ALAN()
    {
        return $this->TESLIM_ALAN;
    }
    /**
     * Set TESLIM_ALAN value
     * @param string $tESLIM_ALAN
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setTESLIM_ALAN($tESLIM_ALAN = null)
    {
        // validation for constraint: string
        if (!is_null($tESLIM_ALAN) && !is_string($tESLIM_ALAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tESLIM_ALAN, true), gettype($tESLIM_ALAN)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($tESLIM_ALAN) && mb_strlen($tESLIM_ALAN) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($tESLIM_ALAN)), __LINE__);
        }
        $this->TESLIM_ALAN = $tESLIM_ALAN;
        return $this;
    }
    /**
     * Get TESLIM_TARIHI value
     * @return string|null
     */
    public function getTESLIM_TARIHI()
    {
        return $this->TESLIM_TARIHI;
    }
    /**
     * Set TESLIM_TARIHI value
     * @param string $tESLIM_TARIHI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setTESLIM_TARIHI($tESLIM_TARIHI = null)
    {
        // validation for constraint: string
        if (!is_null($tESLIM_TARIHI) && !is_string($tESLIM_TARIHI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tESLIM_TARIHI, true), gettype($tESLIM_TARIHI)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($tESLIM_TARIHI) && mb_strlen($tESLIM_TARIHI) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($tESLIM_TARIHI)), __LINE__);
        }
        $this->TESLIM_TARIHI = $tESLIM_TARIHI;
        return $this;
    }
    /**
     * Get TESLIM_SAATI value
     * @return string|null
     */
    public function getTESLIM_SAATI()
    {
        return $this->TESLIM_SAATI;
    }
    /**
     * Set TESLIM_SAATI value
     * @param string $tESLIM_SAATI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setTESLIM_SAATI($tESLIM_SAATI = null)
    {
        // validation for constraint: string
        if (!is_null($tESLIM_SAATI) && !is_string($tESLIM_SAATI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tESLIM_SAATI, true), gettype($tESLIM_SAATI)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($tESLIM_SAATI) && mb_strlen($tESLIM_SAATI) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($tESLIM_SAATI)), __LINE__);
        }
        $this->TESLIM_SAATI = $tESLIM_SAATI;
        return $this;
    }
    /**
     * Get IADE value
     * @return string|null
     */
    public function getIADE()
    {
        return $this->IADE;
    }
    /**
     * Set IADE value
     * @param string $iADE
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA3
     */
    public function setIADE($iADE = null)
    {
        // validation for constraint: string
        if (!is_null($iADE) && !is_string($iADE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iADE, true), gettype($iADE)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($iADE) && mb_strlen($iADE) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($iADE)), __LINE__);
        }
        $this->IADE = $iADE;
        return $this;
    }
}
