<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCARGODATA13 StructType
 * @subpackage Structs
 */
class WEBCARGODATA13 extends AbstractStructBase
{
    /**
     * The ISLEM_TARIHI
     * @var string
     */
    public $ISLEM_TARIHI;
    /**
     * The BIRIM
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $BIRIM;
    /**
     * The ISLEM
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * @var string
     */
    public $ISLEM;
    /**
     * Constructor method for WEBCARGODATA13
     * @uses WEBCARGODATA13::setISLEM_TARIHI()
     * @uses WEBCARGODATA13::setBIRIM()
     * @uses WEBCARGODATA13::setISLEM()
     * @param string $iSLEM_TARIHI
     * @param string $bIRIM
     * @param string $iSLEM
     */
    public function __construct($iSLEM_TARIHI = null, $bIRIM = null, $iSLEM = null)
    {
        $this
            ->setISLEM_TARIHI($iSLEM_TARIHI)
            ->setBIRIM($bIRIM)
            ->setISLEM($iSLEM);
    }
    /**
     * Get ISLEM_TARIHI value
     * @return string|null
     */
    public function getISLEM_TARIHI()
    {
        return $this->ISLEM_TARIHI;
    }
    /**
     * Set ISLEM_TARIHI value
     * @param string $iSLEM_TARIHI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA13
     */
    public function setISLEM_TARIHI($iSLEM_TARIHI = null)
    {
        // validation for constraint: string
        if (!is_null($iSLEM_TARIHI) && !is_string($iSLEM_TARIHI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSLEM_TARIHI, true), gettype($iSLEM_TARIHI)), __LINE__);
        }
        $this->ISLEM_TARIHI = $iSLEM_TARIHI;
        return $this;
    }
    /**
     * Get BIRIM value
     * @return string|null
     */
    public function getBIRIM()
    {
        return $this->BIRIM;
    }
    /**
     * Set BIRIM value
     * @param string $bIRIM
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA13
     */
    public function setBIRIM($bIRIM = null)
    {
        // validation for constraint: string
        if (!is_null($bIRIM) && !is_string($bIRIM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bIRIM, true), gettype($bIRIM)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($bIRIM) && mb_strlen($bIRIM) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($bIRIM)), __LINE__);
        }
        $this->BIRIM = $bIRIM;
        return $this;
    }
    /**
     * Get ISLEM value
     * @return string|null
     */
    public function getISLEM()
    {
        return $this->ISLEM;
    }
    /**
     * Set ISLEM value
     * @param string $iSLEM
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA13
     */
    public function setISLEM($iSLEM = null)
    {
        // validation for constraint: string
        if (!is_null($iSLEM) && !is_string($iSLEM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSLEM, true), gettype($iSLEM)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($iSLEM) && mb_strlen($iSLEM) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($iSLEM)), __LINE__);
        }
        $this->ISLEM = $iSLEM;
        return $this;
    }
}
