<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCARGODATA11 StructType
 * @subpackage Structs
 */
class WEBCARGODATA11 extends AbstractStructBase
{
    /**
     * The NAME
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * @var string
     */
    public $NAME;
    /**
     * The CODE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $CODE;
    /**
     * The SERI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $SERI;
    /**
     * The IRSNO
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $IRSNO;
    /**
     * The REFNO
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $REFNO;
    /**
     * The MOK
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $MOK;
    /**
     * The CIKIS_SUBESI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $CIKIS_SUBESI;
    /**
     * The VARIS_SUBESI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $VARIS_SUBESI;
    /**
     * The ALICI_ADI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $ALICI_ADI;
    /**
     * The SEHIR
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 64
     * @var string
     */
    public $SEHIR;
    /**
     * The GONDERICI_ADI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $GONDERICI_ADI;
    /**
     * The TUTAR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TUTAR;
    /**
     * The ADET
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ADET;
    /**
     * The DESI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DESI;
    /**
     * The IADE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 5
     * - minOccurs: 0
     * @var string
     */
    public $IADE;
    /**
     * The TARIH
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TARIH;
    /**
     * Constructor method for WEBCARGODATA11
     * @uses WEBCARGODATA11::setNAME()
     * @uses WEBCARGODATA11::setCODE()
     * @uses WEBCARGODATA11::setSERI()
     * @uses WEBCARGODATA11::setIRSNO()
     * @uses WEBCARGODATA11::setREFNO()
     * @uses WEBCARGODATA11::setMOK()
     * @uses WEBCARGODATA11::setCIKIS_SUBESI()
     * @uses WEBCARGODATA11::setVARIS_SUBESI()
     * @uses WEBCARGODATA11::setALICI_ADI()
     * @uses WEBCARGODATA11::setSEHIR()
     * @uses WEBCARGODATA11::setGONDERICI_ADI()
     * @uses WEBCARGODATA11::setTUTAR()
     * @uses WEBCARGODATA11::setADET()
     * @uses WEBCARGODATA11::setDESI()
     * @uses WEBCARGODATA11::setIADE()
     * @uses WEBCARGODATA11::setTARIH()
     * @param string $nAME
     * @param string $cODE
     * @param string $sERI
     * @param string $iRSNO
     * @param string $rEFNO
     * @param string $mOK
     * @param string $cIKIS_SUBESI
     * @param string $vARIS_SUBESI
     * @param string $aLICI_ADI
     * @param string $sEHIR
     * @param string $gONDERICI_ADI
     * @param float $tUTAR
     * @param float $aDET
     * @param float $dESI
     * @param string $iADE
     * @param string $tARIH
     */
    public function __construct($nAME = null, $cODE = null, $sERI = null, $iRSNO = null, $rEFNO = null, $mOK = null, $cIKIS_SUBESI = null, $vARIS_SUBESI = null, $aLICI_ADI = null, $sEHIR = null, $gONDERICI_ADI = null, $tUTAR = null, $aDET = null, $dESI = null, $iADE = null, $tARIH = null)
    {
        $this
            ->setNAME($nAME)
            ->setCODE($cODE)
            ->setSERI($sERI)
            ->setIRSNO($iRSNO)
            ->setREFNO($rEFNO)
            ->setMOK($mOK)
            ->setCIKIS_SUBESI($cIKIS_SUBESI)
            ->setVARIS_SUBESI($vARIS_SUBESI)
            ->setALICI_ADI($aLICI_ADI)
            ->setSEHIR($sEHIR)
            ->setGONDERICI_ADI($gONDERICI_ADI)
            ->setTUTAR($tUTAR)
            ->setADET($aDET)
            ->setDESI($dESI)
            ->setIADE($iADE)
            ->setTARIH($tARIH);
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nAME, true), gettype($nAME)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($nAME) && mb_strlen($nAME) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get CODE value
     * @return string|null
     */
    public function getCODE()
    {
        return $this->CODE;
    }
    /**
     * Set CODE value
     * @param string $cODE
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setCODE($cODE = null)
    {
        // validation for constraint: string
        if (!is_null($cODE) && !is_string($cODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cODE, true), gettype($cODE)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($cODE) && mb_strlen($cODE) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($cODE)), __LINE__);
        }
        $this->CODE = $cODE;
        return $this;
    }
    /**
     * Get SERI value
     * @return string|null
     */
    public function getSERI()
    {
        return $this->SERI;
    }
    /**
     * Set SERI value
     * @param string $sERI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setSERI($sERI = null)
    {
        // validation for constraint: string
        if (!is_null($sERI) && !is_string($sERI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sERI, true), gettype($sERI)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($sERI) && mb_strlen($sERI) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($sERI)), __LINE__);
        }
        $this->SERI = $sERI;
        return $this;
    }
    /**
     * Get IRSNO value
     * @return string|null
     */
    public function getIRSNO()
    {
        return $this->IRSNO;
    }
    /**
     * Set IRSNO value
     * @param string $iRSNO
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setIRSNO($iRSNO = null)
    {
        // validation for constraint: string
        if (!is_null($iRSNO) && !is_string($iRSNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iRSNO, true), gettype($iRSNO)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($iRSNO) && mb_strlen($iRSNO) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($iRSNO)), __LINE__);
        }
        $this->IRSNO = $iRSNO;
        return $this;
    }
    /**
     * Get REFNO value
     * @return string|null
     */
    public function getREFNO()
    {
        return $this->REFNO;
    }
    /**
     * Set REFNO value
     * @param string $rEFNO
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setREFNO($rEFNO = null)
    {
        // validation for constraint: string
        if (!is_null($rEFNO) && !is_string($rEFNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEFNO, true), gettype($rEFNO)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($rEFNO) && mb_strlen($rEFNO) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($rEFNO)), __LINE__);
        }
        $this->REFNO = $rEFNO;
        return $this;
    }
    /**
     * Get MOK value
     * @return string|null
     */
    public function getMOK()
    {
        return $this->MOK;
    }
    /**
     * Set MOK value
     * @param string $mOK
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setMOK($mOK = null)
    {
        // validation for constraint: string
        if (!is_null($mOK) && !is_string($mOK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mOK, true), gettype($mOK)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($mOK) && mb_strlen($mOK) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($mOK)), __LINE__);
        }
        $this->MOK = $mOK;
        return $this;
    }
    /**
     * Get CIKIS_SUBESI value
     * @return string|null
     */
    public function getCIKIS_SUBESI()
    {
        return $this->CIKIS_SUBESI;
    }
    /**
     * Set CIKIS_SUBESI value
     * @param string $cIKIS_SUBESI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setCIKIS_SUBESI($cIKIS_SUBESI = null)
    {
        // validation for constraint: string
        if (!is_null($cIKIS_SUBESI) && !is_string($cIKIS_SUBESI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cIKIS_SUBESI, true), gettype($cIKIS_SUBESI)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($cIKIS_SUBESI) && mb_strlen($cIKIS_SUBESI) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($cIKIS_SUBESI)), __LINE__);
        }
        $this->CIKIS_SUBESI = $cIKIS_SUBESI;
        return $this;
    }
    /**
     * Get VARIS_SUBESI value
     * @return string|null
     */
    public function getVARIS_SUBESI()
    {
        return $this->VARIS_SUBESI;
    }
    /**
     * Set VARIS_SUBESI value
     * @param string $vARIS_SUBESI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setVARIS_SUBESI($vARIS_SUBESI = null)
    {
        // validation for constraint: string
        if (!is_null($vARIS_SUBESI) && !is_string($vARIS_SUBESI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vARIS_SUBESI, true), gettype($vARIS_SUBESI)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($vARIS_SUBESI) && mb_strlen($vARIS_SUBESI) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($vARIS_SUBESI)), __LINE__);
        }
        $this->VARIS_SUBESI = $vARIS_SUBESI;
        return $this;
    }
    /**
     * Get ALICI_ADI value
     * @return string|null
     */
    public function getALICI_ADI()
    {
        return $this->ALICI_ADI;
    }
    /**
     * Set ALICI_ADI value
     * @param string $aLICI_ADI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setALICI_ADI($aLICI_ADI = null)
    {
        // validation for constraint: string
        if (!is_null($aLICI_ADI) && !is_string($aLICI_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLICI_ADI, true), gettype($aLICI_ADI)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($aLICI_ADI) && mb_strlen($aLICI_ADI) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($aLICI_ADI)), __LINE__);
        }
        $this->ALICI_ADI = $aLICI_ADI;
        return $this;
    }
    /**
     * Get SEHIR value
     * @return string|null
     */
    public function getSEHIR()
    {
        return $this->SEHIR;
    }
    /**
     * Set SEHIR value
     * @param string $sEHIR
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setSEHIR($sEHIR = null)
    {
        // validation for constraint: string
        if (!is_null($sEHIR) && !is_string($sEHIR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEHIR, true), gettype($sEHIR)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($sEHIR) && mb_strlen($sEHIR) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($sEHIR)), __LINE__);
        }
        $this->SEHIR = $sEHIR;
        return $this;
    }
    /**
     * Get GONDERICI_ADI value
     * @return string|null
     */
    public function getGONDERICI_ADI()
    {
        return $this->GONDERICI_ADI;
    }
    /**
     * Set GONDERICI_ADI value
     * @param string $gONDERICI_ADI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setGONDERICI_ADI($gONDERICI_ADI = null)
    {
        // validation for constraint: string
        if (!is_null($gONDERICI_ADI) && !is_string($gONDERICI_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gONDERICI_ADI, true), gettype($gONDERICI_ADI)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($gONDERICI_ADI) && mb_strlen($gONDERICI_ADI) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($gONDERICI_ADI)), __LINE__);
        }
        $this->GONDERICI_ADI = $gONDERICI_ADI;
        return $this;
    }
    /**
     * Get TUTAR value
     * @return float|null
     */
    public function getTUTAR()
    {
        return $this->TUTAR;
    }
    /**
     * Set TUTAR value
     * @param float $tUTAR
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setTUTAR($tUTAR = null)
    {
        // validation for constraint: float
        if (!is_null($tUTAR) && !(is_float($tUTAR) || is_numeric($tUTAR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tUTAR, true), gettype($tUTAR)), __LINE__);
        }
        $this->TUTAR = $tUTAR;
        return $this;
    }
    /**
     * Get ADET value
     * @return float|null
     */
    public function getADET()
    {
        return $this->ADET;
    }
    /**
     * Set ADET value
     * @param float $aDET
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setADET($aDET = null)
    {
        // validation for constraint: float
        if (!is_null($aDET) && !(is_float($aDET) || is_numeric($aDET))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aDET, true), gettype($aDET)), __LINE__);
        }
        $this->ADET = $aDET;
        return $this;
    }
    /**
     * Get DESI value
     * @return float|null
     */
    public function getDESI()
    {
        return $this->DESI;
    }
    /**
     * Set DESI value
     * @param float $dESI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setDESI($dESI = null)
    {
        // validation for constraint: float
        if (!is_null($dESI) && !(is_float($dESI) || is_numeric($dESI))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dESI, true), gettype($dESI)), __LINE__);
        }
        $this->DESI = $dESI;
        return $this;
    }
    /**
     * Get IADE value
     * @return string|null
     */
    public function getIADE()
    {
        return $this->IADE;
    }
    /**
     * Set IADE value
     * @param string $iADE
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setIADE($iADE = null)
    {
        // validation for constraint: string
        if (!is_null($iADE) && !is_string($iADE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iADE, true), gettype($iADE)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($iADE) && mb_strlen($iADE) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($iADE)), __LINE__);
        }
        $this->IADE = $iADE;
        return $this;
    }
    /**
     * Get TARIH value
     * @return string|null
     */
    public function getTARIH()
    {
        return $this->TARIH;
    }
    /**
     * Set TARIH value
     * @param string $tARIH
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA11
     */
    public function setTARIH($tARIH = null)
    {
        // validation for constraint: string
        if (!is_null($tARIH) && !is_string($tARIH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tARIH, true), gettype($tARIH)), __LINE__);
        }
        $this->TARIH = $tARIH;
        return $this;
    }
}
