<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCARGODATA10 StructType
 * @subpackage Structs
 */
class WEBCARGODATA10 extends AbstractStructBase
{
    /**
     * The GONDERICI_ADI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $GONDERICI_ADI;
    /**
     * The SERI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $SERI;
    /**
     * The FATNO
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $FATNO;
    /**
     * The REFNO
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 6
     * - minOccurs: 0
     * @var string
     */
    public $REFNO;
    /**
     * The ÖT
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $OT;
    /**
     * The FAT_TARIHI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 19
     * - minOccurs: 0
     * @var string
     */
    public $FAT_TARIHI;
    /**
     * The ÇIKIŞ_ŞUBESI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $CIKIS_SUBESI;
    /**
     * The VARIŞ_ŞUBESI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $VARIS_SUBESI;
    /**
     * The ALICI_ADI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $ALICI_ADI;
    /**
     * The ŞEHIR
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 64
     * @var string
     */
    public $SEHIR;
    /**
     * The TUTAR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TUTAR;
    /**
     * The ADET
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ADET;
    /**
     * The DESI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DESI;
    /**
     * The TESLIM_ALAN
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $TESLIM_ALAN;
    /**
     * The TESLIM_TARIHI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $TESLIM_TARIHI;
    /**
     * The TESLIM_SAATI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $TESLIM_SAATI;
    /**
     * The SON_DURUM
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $SON_DURUM;
    /**
     * The KARGONUN_CINSI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * @var string
     */
    public $KARGONUN_CINSI;
    /**
     * The CIKIS_SUBEKODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $CIKIS_SUBEKODU;
    /**
     * The VARIS_SUBEKODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $VARIS_SUBEKODU;
    /**
     * The ILK_CIKIS_SUBEKODU
     * @var float
     */
    public $ILK_CIKIS_SUBEKODU;
    /**
     * The GONDERI_TIPI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * @var string
     */
    public $GONDERI_TIPI;
    /**
     * The ILK_CIKIS
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $ILK_CIKIS;
    /**
     * The WAYBILLID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $WAYBILLID;
    /**
     * Constructor method for WEBCARGODATA10
     * @param string $gONDERICI_ADI
     * @param string $sERI
     * @param string $fATNO
     * @param string $rEFNO
     * @param string $oT
     * @param string $fAT_TARIHI
     * @param string $cIKIS_SUBESI
     * @param string $vARIS_SUBESI
     * @param string $aLICI_ADI
     * @param string $sEHIR
     * @param float $tUTAR
     * @param float $aDET
     * @param float $dESI
     * @param string $tESLIM_ALAN
     * @param string $tESLIM_TARIHI
     * @param string $tESLIM_SAATI
     * @param string $sON_DURUM
     * @param string $kARGONUN_CINSI
     * @param string $cIKIS_SUBEKODU
     * @param string $vARIS_SUBEKODU
     * @param float $iLK_CIKIS_SUBEKODU
     * @param string $gONDERI_TIPI
     * @param string $iLK_CIKIS
     * @param string $wAYBILLID
     *@uses WEBCARGODATA10::setGONDERICI_ADI()
     * @uses WEBCARGODATA10::setSERI()
     * @uses WEBCARGODATA10::setFATNO()
     * @uses WEBCARGODATA10::setREFNO()
     * @uses WEBCARGODATA10::setOT()
     * @uses WEBCARGODATA10::setFAT_TARIHI()
     * @uses WEBCARGODATA10::setCIKISSUBESI()
     * @uses WEBCARGODATA10::setVARISSUBESI()
     * @uses WEBCARGODATA10::setALICI_ADI()
     * @uses WEBCARGODATA10::setSEHIR()
     * @uses WEBCARGODATA10::setTUTAR()
     * @uses WEBCARGODATA10::setADET()
     * @uses WEBCARGODATA10::setDESI()
     * @uses WEBCARGODATA10::setTESLIM_ALAN()
     * @uses WEBCARGODATA10::setTESLIM_TARIHI()
     * @uses WEBCARGODATA10::setTESLIM_SAATI()
     * @uses WEBCARGODATA10::setSON_DURUM()
     * @uses WEBCARGODATA10::setKARGONUN_CINSI()
     * @uses WEBCARGODATA10::setCIKIS_SUBEKODU()
     * @uses WEBCARGODATA10::setVARIS_SUBEKODU()
     * @uses WEBCARGODATA10::setILK_CIKIS_SUBEKODU()
     * @uses WEBCARGODATA10::setGONDERI_TIPI()
     * @uses WEBCARGODATA10::setILK_CIKIS()
     * @uses WEBCARGODATA10::setWAYBILLID()
     */
    public function __construct($gONDERICI_ADI = null, $sERI = null, $fATNO = null, $rEFNO = null, $oT = null, $fAT_TARIHI = null, $cIKIS_SUBESI = null, $vARIS_SUBESI = null, $aLICI_ADI = null, $sEHIR = null, $tUTAR = null, $aDET = null, $dESI = null, $tESLIM_ALAN = null, $tESLIM_TARIHI = null, $tESLIM_SAATI = null, $sON_DURUM = null, $kARGONUN_CINSI = null, $cIKIS_SUBEKODU = null, $vARIS_SUBEKODU = null, $iLK_CIKIS_SUBEKODU = null, $gONDERI_TIPI = null, $iLK_CIKIS = null, $wAYBILLID = null)
    {
        $this
            ->setGONDERICI_ADI($gONDERICI_ADI)
            ->setSERI($sERI)
            ->setFATNO($fATNO)
            ->setREFNO($rEFNO)
            ->setOT($oT)
            ->setFAT_TARIHI($fAT_TARIHI)
            ->setCIKISSUBESI($cIKIS_SUBESI)
            ->setVARISSUBESI($vARIS_SUBESI)
            ->setALICI_ADI($aLICI_ADI)
            ->setSEHIR($sEHIR)
            ->setTUTAR($tUTAR)
            ->setADET($aDET)
            ->setDESI($dESI)
            ->setTESLIM_ALAN($tESLIM_ALAN)
            ->setTESLIM_TARIHI($tESLIM_TARIHI)
            ->setTESLIM_SAATI($tESLIM_SAATI)
            ->setSON_DURUM($sON_DURUM)
            ->setKARGONUN_CINSI($kARGONUN_CINSI)
            ->setCIKIS_SUBEKODU($cIKIS_SUBEKODU)
            ->setVARIS_SUBEKODU($vARIS_SUBEKODU)
            ->setILK_CIKIS_SUBEKODU($iLK_CIKIS_SUBEKODU)
            ->setGONDERI_TIPI($gONDERI_TIPI)
            ->setILK_CIKIS($iLK_CIKIS)
            ->setWAYBILLID($wAYBILLID);
    }
    /**
     * Get GONDERICI_ADI value
     * @return string|null
     */
    public function getGONDERICI_ADI()
    {
        return $this->GONDERICI_ADI;
    }
    /**
     * Set GONDERICI_ADI value
     * @param string $gONDERICI_ADI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setGONDERICI_ADI($gONDERICI_ADI = null)
    {
        // validation for constraint: string
        if (!is_null($gONDERICI_ADI) && !is_string($gONDERICI_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gONDERICI_ADI, true), gettype($gONDERICI_ADI)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($gONDERICI_ADI) && mb_strlen($gONDERICI_ADI) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($gONDERICI_ADI)), __LINE__);
        }
        $this->GONDERICI_ADI = $gONDERICI_ADI;
        return $this;
    }
    /**
     * Get SERI value
     * @return string|null
     */
    public function getSERI()
    {
        return $this->SERI;
    }
    /**
     * Set SERI value
     * @param string $sERI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setSERI($sERI = null)
    {
        // validation for constraint: string
        if (!is_null($sERI) && !is_string($sERI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sERI, true), gettype($sERI)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($sERI) && mb_strlen($sERI) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($sERI)), __LINE__);
        }
        $this->SERI = $sERI;
        return $this;
    }
    /**
     * Get FATNO value
     * @return string|null
     */
    public function getFATNO()
    {
        return $this->FATNO;
    }
    /**
     * Set FATNO value
     * @param string $fATNO
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setFATNO($fATNO = null)
    {
        // validation for constraint: string
        if (!is_null($fATNO) && !is_string($fATNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fATNO, true), gettype($fATNO)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($fATNO) && mb_strlen($fATNO) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($fATNO)), __LINE__);
        }
        $this->FATNO = $fATNO;
        return $this;
    }
    /**
     * Get REFNO value
     * @return string|null
     */
    public function getREFNO()
    {
        return $this->REFNO;
    }
    /**
     * Set REFNO value
     * @param string $rEFNO
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setREFNO($rEFNO = null)
    {
        // validation for constraint: string
        if (!is_null($rEFNO) && !is_string($rEFNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEFNO, true), gettype($rEFNO)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($rEFNO) && mb_strlen($rEFNO) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($rEFNO)), __LINE__);
        }
        $this->REFNO = $rEFNO;
        return $this;
    }
    /**
     * Get ÖT value
     * @return string|null
     */
    public function getOT()
    {
        return $this->OT;
    }
    /**
     * Set ÖT value
     * @param string $oT
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setOT($oT = null)
    {
        // validation for constraint: string
        if (!is_null($oT) && !is_string($oT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oT, true), gettype($oT)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($oT) && mb_strlen($oT) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($oT)), __LINE__);
        }
        $this->OT = $oT;
        return $this;
    }
    /**
     * Get FAT_TARIHI value
     * @return string|null
     */
    public function getFAT_TARIHI()
    {
        return $this->FAT_TARIHI;
    }
    /**
     * Set FAT_TARIHI value
     * @param string $fAT_TARIHI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setFAT_TARIHI($fAT_TARIHI = null)
    {
        // validation for constraint: string
        if (!is_null($fAT_TARIHI) && !is_string($fAT_TARIHI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fAT_TARIHI, true), gettype($fAT_TARIHI)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($fAT_TARIHI) && mb_strlen($fAT_TARIHI) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($fAT_TARIHI)), __LINE__);
        }
        $this->FAT_TARIHI = $fAT_TARIHI;
        return $this;
    }
    /**
     * Get ÇIKIŞ_ŞUBESI value
     * @return string|null
     */
    public function getCIKISSUBESI()
    {
        return $this->CIKIS_SUBESI;
    }
    /**
     * Set ÇIKIŞ_ŞUBESI value
     * @param string $cIKIS_SUBESI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setCIKISSUBESI($cIKIS_SUBESI = null)
    {
        // validation for constraint: string
        if (!is_null($cIKIS_SUBESI) && !is_string($cIKIS_SUBESI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cIKIS_SUBESI, true), gettype($cIKIS_SUBESI)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($cIKIS_SUBESI) && mb_strlen($cIKIS_SUBESI) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($cIKIS_SUBESI)), __LINE__);
        }
        $this->CIKIS_SUBESI = $cIKIS_SUBESI;
        return $this;
    }
    /**
     * Get VARIŞ_ŞUBESI value
     * @return string|null
     */
    public function getVARISSUBESI()
    {
        return $this->VARIS_SUBESI;
    }
    /**
     * Set VARIŞ_ŞUBESI value
     * @param string $vARIS_SUBESI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setVARISSUBESI($vARIS_SUBESI = null)
    {
        // validation for constraint: string
        if (!is_null($vARIS_SUBESI) && !is_string($vARIS_SUBESI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vARIS_SUBESI, true), gettype($vARIS_SUBESI)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($vARIS_SUBESI) && mb_strlen($vARIS_SUBESI) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($vARIS_SUBESI)), __LINE__);
        }
        $this->VARIS_SUBESI = $vARIS_SUBESI;
        return $this;
    }
    /**
     * Get ALICI_ADI value
     * @return string|null
     */
    public function getALICI_ADI()
    {
        return $this->ALICI_ADI;
    }
    /**
     * Set ALICI_ADI value
     * @param string $aLICI_ADI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setALICI_ADI($aLICI_ADI = null)
    {
        // validation for constraint: string
        if (!is_null($aLICI_ADI) && !is_string($aLICI_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLICI_ADI, true), gettype($aLICI_ADI)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($aLICI_ADI) && mb_strlen($aLICI_ADI) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($aLICI_ADI)), __LINE__);
        }
        $this->ALICI_ADI = $aLICI_ADI;
        return $this;
    }
    /**
     * Get ŞEHIR value
     * @return string|null
     */
    public function getSEHIR()
    {
        return $this->SEHIR;
    }
    /**
     * Set ŞEHIR value
     * @param string $sEHIR
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setSEHIR($sEHIR = null)
    {
        // validation for constraint: string
        if (!is_null($sEHIR) && !is_string($sEHIR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEHIR, true), gettype($sEHIR)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($sEHIR) && mb_strlen($sEHIR) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($sEHIR)), __LINE__);
        }
        $this->SEHIR = $sEHIR;
        return $this;
    }
    /**
     * Get TUTAR value
     * @return float|null
     */
    public function getTUTAR()
    {
        return $this->TUTAR;
    }
    /**
     * Set TUTAR value
     * @param float $tUTAR
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setTUTAR($tUTAR = null)
    {
        // validation for constraint: float
        if (!is_null($tUTAR) && !(is_float($tUTAR) || is_numeric($tUTAR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tUTAR, true), gettype($tUTAR)), __LINE__);
        }
        $this->TUTAR = $tUTAR;
        return $this;
    }
    /**
     * Get ADET value
     * @return float|null
     */
    public function getADET()
    {
        return $this->ADET;
    }
    /**
     * Set ADET value
     * @param float $aDET
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setADET($aDET = null)
    {
        // validation for constraint: float
        if (!is_null($aDET) && !(is_float($aDET) || is_numeric($aDET))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aDET, true), gettype($aDET)), __LINE__);
        }
        $this->ADET = $aDET;
        return $this;
    }
    /**
     * Get DESI value
     * @return float|null
     */
    public function getDESI()
    {
        return $this->DESI;
    }
    /**
     * Set DESI value
     * @param float $dESI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setDESI($dESI = null)
    {
        // validation for constraint: float
        if (!is_null($dESI) && !(is_float($dESI) || is_numeric($dESI))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dESI, true), gettype($dESI)), __LINE__);
        }
        $this->DESI = $dESI;
        return $this;
    }
    /**
     * Get TESLIM_ALAN value
     * @return string|null
     */
    public function getTESLIM_ALAN()
    {
        return $this->TESLIM_ALAN;
    }
    /**
     * Set TESLIM_ALAN value
     * @param string $tESLIM_ALAN
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setTESLIM_ALAN($tESLIM_ALAN = null)
    {
        // validation for constraint: string
        if (!is_null($tESLIM_ALAN) && !is_string($tESLIM_ALAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tESLIM_ALAN, true), gettype($tESLIM_ALAN)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($tESLIM_ALAN) && mb_strlen($tESLIM_ALAN) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($tESLIM_ALAN)), __LINE__);
        }
        $this->TESLIM_ALAN = $tESLIM_ALAN;
        return $this;
    }
    /**
     * Get TESLIM_TARIHI value
     * @return string|null
     */
    public function getTESLIM_TARIHI()
    {
        return $this->TESLIM_TARIHI;
    }
    /**
     * Set TESLIM_TARIHI value
     * @param string $tESLIM_TARIHI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setTESLIM_TARIHI($tESLIM_TARIHI = null)
    {
        // validation for constraint: string
        if (!is_null($tESLIM_TARIHI) && !is_string($tESLIM_TARIHI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tESLIM_TARIHI, true), gettype($tESLIM_TARIHI)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($tESLIM_TARIHI) && mb_strlen($tESLIM_TARIHI) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($tESLIM_TARIHI)), __LINE__);
        }
        $this->TESLIM_TARIHI = $tESLIM_TARIHI;
        return $this;
    }
    /**
     * Get TESLIM_SAATI value
     * @return string|null
     */
    public function getTESLIM_SAATI()
    {
        return $this->TESLIM_SAATI;
    }
    /**
     * Set TESLIM_SAATI value
     * @param string $tESLIM_SAATI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setTESLIM_SAATI($tESLIM_SAATI = null)
    {
        // validation for constraint: string
        if (!is_null($tESLIM_SAATI) && !is_string($tESLIM_SAATI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tESLIM_SAATI, true), gettype($tESLIM_SAATI)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($tESLIM_SAATI) && mb_strlen($tESLIM_SAATI) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($tESLIM_SAATI)), __LINE__);
        }
        $this->TESLIM_SAATI = $tESLIM_SAATI;
        return $this;
    }
    /**
     * Get SON_DURUM value
     * @return string|null
     */
    public function getSON_DURUM()
    {
        return $this->SON_DURUM;
    }
    /**
     * Set SON_DURUM value
     * @param string $sON_DURUM
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setSON_DURUM($sON_DURUM = null)
    {
        // validation for constraint: string
        if (!is_null($sON_DURUM) && !is_string($sON_DURUM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sON_DURUM, true), gettype($sON_DURUM)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($sON_DURUM) && mb_strlen($sON_DURUM) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($sON_DURUM)), __LINE__);
        }
        $this->SON_DURUM = $sON_DURUM;
        return $this;
    }
    /**
     * Get KARGONUN_CINSI value
     * @return string|null
     */
    public function getKARGONUN_CINSI()
    {
        return $this->KARGONUN_CINSI;
    }
    /**
     * Set KARGONUN_CINSI value
     * @param string $kARGONUN_CINSI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setKARGONUN_CINSI($kARGONUN_CINSI = null)
    {
        // validation for constraint: string
        if (!is_null($kARGONUN_CINSI) && !is_string($kARGONUN_CINSI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kARGONUN_CINSI, true), gettype($kARGONUN_CINSI)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($kARGONUN_CINSI) && mb_strlen($kARGONUN_CINSI) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($kARGONUN_CINSI)), __LINE__);
        }
        $this->KARGONUN_CINSI = $kARGONUN_CINSI;
        return $this;
    }
    /**
     * Get CIKIS_SUBEKODU value
     * @return string|null
     */
    public function getCIKIS_SUBEKODU()
    {
        return $this->CIKIS_SUBEKODU;
    }
    /**
     * Set CIKIS_SUBEKODU value
     * @param string $cIKIS_SUBEKODU
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setCIKIS_SUBEKODU($cIKIS_SUBEKODU = null)
    {
        // validation for constraint: string
        if (!is_null($cIKIS_SUBEKODU) && !is_string($cIKIS_SUBEKODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cIKIS_SUBEKODU, true), gettype($cIKIS_SUBEKODU)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($cIKIS_SUBEKODU) && mb_strlen($cIKIS_SUBEKODU) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($cIKIS_SUBEKODU)), __LINE__);
        }
        $this->CIKIS_SUBEKODU = $cIKIS_SUBEKODU;
        return $this;
    }
    /**
     * Get VARIS_SUBEKODU value
     * @return string|null
     */
    public function getVARIS_SUBEKODU()
    {
        return $this->VARIS_SUBEKODU;
    }
    /**
     * Set VARIS_SUBEKODU value
     * @param string $vARIS_SUBEKODU
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setVARIS_SUBEKODU($vARIS_SUBEKODU = null)
    {
        // validation for constraint: string
        if (!is_null($vARIS_SUBEKODU) && !is_string($vARIS_SUBEKODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vARIS_SUBEKODU, true), gettype($vARIS_SUBEKODU)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($vARIS_SUBEKODU) && mb_strlen($vARIS_SUBEKODU) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($vARIS_SUBEKODU)), __LINE__);
        }
        $this->VARIS_SUBEKODU = $vARIS_SUBEKODU;
        return $this;
    }
    /**
     * Get ILK_CIKIS_SUBEKODU value
     * @return float|null
     */
    public function getILK_CIKIS_SUBEKODU()
    {
        return $this->ILK_CIKIS_SUBEKODU;
    }
    /**
     * Set ILK_CIKIS_SUBEKODU value
     * @param float $iLK_CIKIS_SUBEKODU
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setILK_CIKIS_SUBEKODU($iLK_CIKIS_SUBEKODU = null)
    {
        // validation for constraint: float
        if (!is_null($iLK_CIKIS_SUBEKODU) && !(is_float($iLK_CIKIS_SUBEKODU) || is_numeric($iLK_CIKIS_SUBEKODU))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iLK_CIKIS_SUBEKODU, true), gettype($iLK_CIKIS_SUBEKODU)), __LINE__);
        }
        $this->ILK_CIKIS_SUBEKODU = $iLK_CIKIS_SUBEKODU;
        return $this;
    }
    /**
     * Get GONDERI_TIPI value
     * @return string|null
     */
    public function getGONDERI_TIPI()
    {
        return $this->GONDERI_TIPI;
    }
    /**
     * Set GONDERI_TIPI value
     * @param string $gONDERI_TIPI
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setGONDERI_TIPI($gONDERI_TIPI = null)
    {
        // validation for constraint: string
        if (!is_null($gONDERI_TIPI) && !is_string($gONDERI_TIPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gONDERI_TIPI, true), gettype($gONDERI_TIPI)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($gONDERI_TIPI) && mb_strlen($gONDERI_TIPI) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($gONDERI_TIPI)), __LINE__);
        }
        $this->GONDERI_TIPI = $gONDERI_TIPI;
        return $this;
    }
    /**
     * Get ILK_CIKIS value
     * @return string|null
     */
    public function getILK_CIKIS()
    {
        return $this->ILK_CIKIS;
    }
    /**
     * Set ILK_CIKIS value
     * @param string $iLK_CIKIS
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setILK_CIKIS($iLK_CIKIS = null)
    {
        // validation for constraint: string
        if (!is_null($iLK_CIKIS) && !is_string($iLK_CIKIS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iLK_CIKIS, true), gettype($iLK_CIKIS)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($iLK_CIKIS) && mb_strlen($iLK_CIKIS) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($iLK_CIKIS)), __LINE__);
        }
        $this->ILK_CIKIS = $iLK_CIKIS;
        return $this;
    }
    /**
     * Get WAYBILLID value
     * @return string|null
     */
    public function getWAYBILLID()
    {
        return $this->WAYBILLID;
    }
    /**
     * Set WAYBILLID value
     * @param string $wAYBILLID
     * @return \Ys\ArasOrder\StructType\WEBCARGODATA10
     */
    public function setWAYBILLID($wAYBILLID = null)
    {
        // validation for constraint: string
        if (!is_null($wAYBILLID) && !is_string($wAYBILLID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wAYBILLID, true), gettype($wAYBILLID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($wAYBILLID) && mb_strlen($wAYBILLID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($wAYBILLID)), __LINE__);
        }
        $this->WAYBILLID = $wAYBILLID;
        return $this;
    }
}
